/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.databind.JsonNode;
import io.orchestrate.client.BaseResource;
import io.orchestrate.client.JacksonMapper;
import io.orchestrate.client.KvList;
import io.orchestrate.client.OrchestrateClient;
import io.orchestrate.client.OrchestrateRequest;
import io.orchestrate.client.Preconditions;
import io.orchestrate.client.ResponseConverter;
import io.orchestrate.client.ResponseConverterUtil;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.util.UEncoder;

public class KvListResource
extends BaseResource {
    private final String collection;
    @Nullable
    private String startKey;
    private boolean inclusive;
    private int limit;

    KvListResource(OrchestrateClient client, JacksonMapper mapper, String collection) {
        super(client, mapper);
        assert (collection != null);
        assert (collection.length() > 0);
        this.collection = collection;
        this.inclusive = false;
        this.limit = 10;
    }

    public <T> OrchestrateRequest<KvList<T>> get(final @NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        Preconditions.checkArgument(!this.inclusive || this.startKey != null, "'inclusive' requires 'startKey' for request.");
        UEncoder urlEncoder = new UEncoder();
        final String uri = urlEncoder.encodeURL(this.collection);
        String query = "limit=".concat(this.limit + "");
        if (this.startKey != null) {
            String keyName = this.inclusive ? "startKey" : "afterKey";
            query = query.concat('&' + keyName + '=').concat(urlEncoder.encodeURL(this.startKey));
        }
        HttpContent packet = HttpRequestPacket.builder().method(Method.GET).uri(uri).query(query).build().httpContentBuilder().build();
        return new OrchestrateRequest<KvList<T>>(this.client, packet, new ResponseConverter<KvList<T>>(){

            @Override
            public KvList<T> from(HttpContent response) throws IOException {
                OrchestrateRequest next;
                int status = ((HttpResponsePacket)response.getHttpHeader()).getStatus();
                assert (status == 200);
                String json = response.getContent().toStringContent(Charset.forName("UTF-8"));
                JsonNode jsonNode = KvListResource.this.mapper.readTree(json);
                if (jsonNode.has("next")) {
                    String page = jsonNode.get("next").asText();
                    URI url = URI.create(page);
                    HttpContent packet = HttpRequestPacket.builder().method(Method.GET).uri(uri).query(url.getQuery()).build().httpContentBuilder().build();
                    next = new OrchestrateRequest(KvListResource.this.client, packet, this);
                } else {
                    next = null;
                }
                int count = jsonNode.get("count").asInt();
                ArrayList results = new ArrayList(count);
                Iterator iter = jsonNode.get("results").elements();
                while (iter.hasNext()) {
                    results.add(ResponseConverterUtil.jsonToKvObject(KvListResource.this.mapper, (JsonNode)iter.next(), clazz));
                }
                return new KvList(results, count, next);
            }
        });
    }

    public KvListResource inclusive() {
        return this.inclusive(Boolean.TRUE);
    }

    public KvListResource inclusive(boolean inclusive) {
        this.inclusive = inclusive;
        return this;
    }

    public KvListResource limit(int limit) {
        this.limit = Preconditions.checkNotNegative(limit, "limit");
        return this;
    }

    public KvListResource startKey(String startKey) {
        this.startKey = Preconditions.checkNotNullOrEmpty(startKey, "startKey");
        return this;
    }
}

