/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.databind.JsonNode;
import io.orchestrate.client.BaseResource;
import io.orchestrate.client.Event;
import io.orchestrate.client.EventList;
import io.orchestrate.client.JacksonMapper;
import io.orchestrate.client.OrchestrateClient;
import io.orchestrate.client.OrchestrateRequest;
import io.orchestrate.client.Preconditions;
import io.orchestrate.client.ResponseConverter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.util.UEncoder;
import org.glassfish.grizzly.memory.ByteBufferWrapper;

public class EventResource
extends BaseResource {
    private final String collection;
    private final String key;
    private String type;
    private Long start;
    private Long end;

    EventResource(OrchestrateClient client, JacksonMapper mapper, String collection, String key) {
        super(client, mapper);
        assert (collection != null);
        assert (collection.length() > 0);
        assert (key != null);
        assert (key.length() > 0);
        this.collection = collection;
        this.key = key;
        this.start = null;
        this.end = null;
    }

    public <T> OrchestrateRequest<EventList<T>> get(final Class<T> clazz) {
        Preconditions.checkNotNull(clazz, "clazz");
        Preconditions.checkNotNull(this.type, "type");
        UEncoder urlEncoder = new UEncoder();
        String uri = urlEncoder.encodeURL(this.collection).concat("/").concat(urlEncoder.encodeURL(this.key)).concat("/events/").concat(urlEncoder.encodeURL(this.type));
        HttpRequestPacket.Builder httpHeaderBuilder = HttpRequestPacket.builder().method(Method.GET).uri(uri);
        String query = null;
        if (this.start != null) {
            query = query + "start=" + this.start;
        }
        if (this.end != null) {
            query = query + "&end=" + this.end;
        }
        httpHeaderBuilder.query(query);
        HttpContent packet = httpHeaderBuilder.build().httpContentBuilder().build();
        return new OrchestrateRequest<EventList<T>>(this.client, packet, new ResponseConverter<EventList<T>>(){

            @Override
            public EventList<T> from(HttpContent response) throws IOException {
                int status = ((HttpResponsePacket)response.getHttpHeader()).getStatus();
                assert (status == 200);
                String json = response.getContent().toStringContent(Charset.forName("UTF-8"));
                JsonNode jsonNode = EventResource.this.mapper.readTree(json);
                int count = jsonNode.get("count").asInt();
                ArrayList events = new ArrayList(count);
                Iterator iter = jsonNode.get("results").elements();
                while (iter.hasNext()) {
                    JsonNode result = (JsonNode)iter.next();
                    long timestamp = result.get("timestamp").asLong();
                    JsonNode valueNode = result.get("value");
                    String rawValue = valueNode.toString();
                    String value = clazz == String.class ? rawValue : EventResource.this.mapper.readValue(rawValue, clazz);
                    events.add(new Event<String>(value, rawValue, timestamp));
                }
                return new EventList(events);
            }
        });
    }

    public OrchestrateRequest<Boolean> put(@NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        return this.put(value, null);
    }

    public OrchestrateRequest<Boolean> put(@NonNull Object value, @Nullable Long timestamp) {
        byte[] content;
        if (value == null) {
            throw new NullPointerException("value");
        }
        Preconditions.checkNotNull(this.type, "type");
        Preconditions.checkArgument(this.start == null && this.end == null, "'start' and 'end' not allowed with PUT requests.");
        try {
            content = value instanceof String ? ((String)value).getBytes("UTF-8") : this.mapper.writeValueAsBytes(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        UEncoder urlEncoder = new UEncoder();
        String uri = urlEncoder.encodeURL(this.collection).concat("/").concat(urlEncoder.encodeURL(this.key)).concat("/events/").concat(urlEncoder.encodeURL(this.type));
        HttpRequestPacket.Builder httpHeaderBuilder = ((HttpRequestPacket.Builder)HttpRequestPacket.builder().method(Method.PUT).contentType("application/json")).uri(uri);
        if (timestamp != null) {
            httpHeaderBuilder.query("timestamp=" + timestamp);
        }
        httpHeaderBuilder.contentLength((long)content.length);
        HttpContent packet = httpHeaderBuilder.build().httpContentBuilder().content((Buffer)new ByteBufferWrapper(ByteBuffer.wrap(content))).build();
        return new OrchestrateRequest<Boolean>(this.client, packet, new ResponseConverter<Boolean>(){

            @Override
            public Boolean from(HttpContent response) throws IOException {
                int status = ((HttpResponsePacket)response.getHttpHeader()).getStatus();
                return status == 204;
            }
        });
    }

    public EventResource type(String type) {
        this.type = Preconditions.checkNotNullOrEmpty(type, "type");
        return this;
    }

    public EventResource start(long start) {
        this.start = start;
        return this;
    }

    public EventResource end(long end) {
        this.end = end;
        return this;
    }
}

