/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.orchestrate.client.AggregateResult;
import io.orchestrate.client.CountedValue;
import java.util.ArrayList;
import java.util.List;

public class TopValuesAggregateResult
extends AggregateResult {
    private final List<CountedValue> entries;
    private final int offset;
    private final int limit;

    TopValuesAggregateResult(String fieldName, long valueCount, List<CountedValue> entries, int offset, int limit) {
        super(fieldName, "top_values", valueCount);
        this.entries = entries;
        this.offset = offset;
        this.limit = limit;
    }

    public List<CountedValue> getEntries() {
        return this.entries;
    }

    public int getOffset() {
        return this.offset;
    }

    public double getLimit() {
        return this.limit;
    }

    static TopValuesAggregateResult from(JsonNode json) {
        String fieldName = json.get("field_name").asText();
        long valueCount = json.get("value_count").asLong();
        String aggregateKind = json.get("aggregate_kind").asText();
        assert (aggregateKind.equals("top_values"));
        int offset = json.get("offset").asInt();
        int limit = json.get("limit").asInt();
        ArrayList<CountedValue> entries = new ArrayList<CountedValue>();
        for (JsonNode entryNode : (ArrayNode)json.get("entries")) {
            JsonNode valueNode = entryNode.get("value");
            long count = entryNode.get("count").asLong();
            if (valueNode == null || valueNode.isNull()) {
                entries.add(new CountedValue(null, count));
                continue;
            }
            if (valueNode.isBoolean()) {
                entries.add(new CountedValue(valueNode.asBoolean(), count));
                continue;
            }
            if (valueNode.isNumber()) {
                entries.add(new CountedValue(valueNode.asDouble(), count));
                continue;
            }
            if (!valueNode.isTextual()) continue;
            entries.add(new CountedValue(valueNode.asText(), count));
        }
        return new TopValuesAggregateResult(fieldName, valueCount, entries, offset, limit);
    }
}

