/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.databind.JsonNode;
import io.orchestrate.client.AggregateResult;

public class StatsAggregateResult
extends AggregateResult {
    private final double min;
    private final double max;
    private final double mean;
    private final double sum;
    private final double sumOfSquares;
    private final double variance;
    private final double stdDev;

    StatsAggregateResult(String fieldName, long valueCount, double min, double max, double mean, double sum, double sumOfSquares, double variance, double stdDev) {
        super(fieldName, "stats", valueCount);
        this.min = min;
        this.max = max;
        this.mean = mean;
        this.sum = sum;
        this.sumOfSquares = sumOfSquares;
        this.variance = variance;
        this.stdDev = stdDev;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getMean() {
        return this.mean;
    }

    public double getSum() {
        return this.sum;
    }

    public double getSumOfSquares() {
        return this.sumOfSquares;
    }

    public double getVariance() {
        return this.variance;
    }

    public double getStdDev() {
        return this.stdDev;
    }

    static StatsAggregateResult from(JsonNode json) {
        String fieldName = json.get("field_name").asText();
        long valueCount = json.get("value_count").asLong();
        String aggregateKind = json.get("aggregate_kind").asText();
        assert (aggregateKind.equals("stats"));
        JsonNode statistics = json.get("statistics");
        double min = statistics.get("min").asDouble();
        double max = statistics.get("max").asDouble();
        double mean = statistics.get("mean").asDouble();
        double sum = statistics.get("sum").asDouble();
        double sumOfSquares = statistics.get("sum_of_squares").asDouble();
        double variance = statistics.get("variance").asDouble();
        double stdDev = statistics.get("std_dev").asDouble();
        return new StatsAggregateResult(fieldName, valueCount, min, max, mean, sum, sumOfSquares, variance, stdDev);
    }
}

