/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import io.orchestrate.client.AggregateResult;
import io.orchestrate.client.OrchestrateRequest;
import io.orchestrate.client.Result;
import java.util.Iterator;
import java.util.List;

public class SearchResults<T>
implements Iterable<Result<T>> {
    private final List<Result<T>> results;
    private final int totalCount;
    private final List<AggregateResult> aggregates;
    private final OrchestrateRequest<SearchResults<T>> next;
    private final OrchestrateRequest<SearchResults<T>> prev;

    SearchResults(List<Result<T>> results, int totalCount, List<AggregateResult> aggregates, OrchestrateRequest<SearchResults<T>> next, OrchestrateRequest<SearchResults<T>> prev) {
        assert (results != null);
        assert (totalCount >= 0);
        this.results = results;
        this.totalCount = totalCount;
        this.aggregates = aggregates;
        this.next = next;
        this.prev = prev;
    }

    public final Iterable<Result<T>> getResults() {
        return this.results;
    }

    public final Iterable<AggregateResult> getAggregates() {
        return this.aggregates;
    }

    public final int getCount() {
        return this.results.size();
    }

    public final int getTotalCount() {
        return this.totalCount;
    }

    @Override
    public final Iterator<Result<T>> iterator() {
        return this.results.iterator();
    }

    public OrchestrateRequest<SearchResults<T>> getNext() {
        return this.next;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public OrchestrateRequest<SearchResults<T>> getPrev() {
        return this.prev;
    }

    public boolean hasPrev() {
        return this.prev != null;
    }

    public String toString() {
        return "SearchResults(results=" + this.getResults() + ", totalCount=" + this.getTotalCount() + ", aggregates=" + this.getAggregates() + ", next=" + this.getNext() + ", prev=" + this.getPrev() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SearchResults)) {
            return false;
        }
        SearchResults other = (SearchResults)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Iterable<Result<T>> this$results = this.getResults();
        Iterable<Result<T>> other$results = other.getResults();
        if (this$results == null ? other$results != null : !this$results.equals(other$results)) {
            return false;
        }
        if (this.getTotalCount() != other.getTotalCount()) {
            return false;
        }
        Iterable<AggregateResult> this$aggregates = this.getAggregates();
        Iterable<AggregateResult> other$aggregates = other.getAggregates();
        if (this$aggregates == null ? other$aggregates != null : !this$aggregates.equals(other$aggregates)) {
            return false;
        }
        OrchestrateRequest<SearchResults<T>> this$next = this.getNext();
        OrchestrateRequest<SearchResults<T>> other$next = other.getNext();
        if (this$next == null ? other$next != null : !this$next.equals(other$next)) {
            return false;
        }
        OrchestrateRequest<SearchResults<T>> this$prev = this.getPrev();
        OrchestrateRequest<SearchResults<T>> other$prev = other.getPrev();
        return !(this$prev == null ? other$prev != null : !this$prev.equals(other$prev));
    }

    public boolean canEqual(Object other) {
        return other instanceof SearchResults;
    }

    public int hashCode() {
        int PRIME = 277;
        int result = 1;
        Iterable<Result<T>> $results = this.getResults();
        result = result * 277 + ($results == null ? 0 : $results.hashCode());
        result = result * 277 + this.getTotalCount();
        Iterable<AggregateResult> $aggregates = this.getAggregates();
        result = result * 277 + ($aggregates == null ? 0 : $aggregates.hashCode());
        OrchestrateRequest<SearchResults<T>> $next = this.getNext();
        result = result * 277 + ($next == null ? 0 : $next.hashCode());
        OrchestrateRequest<SearchResults<T>> $prev = this.getPrev();
        result = result * 277 + ($prev == null ? 0 : $prev.hashCode());
        return result;
    }
}

