/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import io.orchestrate.client.Event;
import io.orchestrate.client.ItemKind;
import io.orchestrate.client.KvObject;
import io.orchestrate.client.Relationship;
import javax.annotation.Nullable;

public class Result<T> {
    private final KvObject<T> kvObject;
    private final double score;
    private final Double distance;

    Result(KvObject<T> kvObject, double score, Double distance) {
        assert (kvObject != null);
        assert (score >= 0.0);
        this.kvObject = kvObject;
        this.score = score;
        this.distance = distance;
    }

    public final KvObject<T> getKvObject() {
        return this.kvObject;
    }

    public final boolean isEvent() {
        return this.kvObject.getItemKind().equals((Object)ItemKind.EVENT);
    }

    public final boolean isRelationship() {
        return this.kvObject.getItemKind().equals((Object)ItemKind.RELATIONSHIP);
    }

    public final Event<T> getEventObject() {
        if (!this.isEvent()) {
            throw new IllegalStateException("Item is not an event.");
        }
        return (Event)this.kvObject;
    }

    public final Relationship<T> getRelationshipObject() {
        if (!this.isRelationship()) {
            throw new IllegalStateException("Item is not a relationship.");
        }
        return (Relationship)this.kvObject;
    }

    public final double getScore() {
        return this.score;
    }

    @Nullable
    public final Double getDistance() {
        return this.distance;
    }

    public String toString() {
        return "Result(kvObject=" + this.getKvObject() + ", score=" + this.getScore() + ", distance=" + this.getDistance() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        KvObject<T> this$kvObject = this.getKvObject();
        KvObject<T> other$kvObject = other.getKvObject();
        if (this$kvObject == null ? other$kvObject != null : !((Object)this$kvObject).equals(other$kvObject)) {
            return false;
        }
        if (Double.compare(this.getScore(), other.getScore()) != 0) {
            return false;
        }
        Double this$distance = this.getDistance();
        Double other$distance = other.getDistance();
        return !(this$distance == null ? other$distance != null : !((Object)this$distance).equals(other$distance));
    }

    public boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 277;
        int result = 1;
        KvObject<T> $kvObject = this.getKvObject();
        result = result * 277 + ($kvObject == null ? 0 : ((Object)$kvObject).hashCode());
        long $score = Double.doubleToLongBits(this.getScore());
        result = result * 277 + (int)($score >>> 32 ^ $score);
        Double $distance = this.getDistance();
        result = result * 277 + ($distance == null ? 0 : ((Object)$distance).hashCode());
        return result;
    }
}

