/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.databind.JsonNode;
import io.orchestrate.client.BaseResource;
import io.orchestrate.client.JacksonMapper;
import io.orchestrate.client.OrchestrateClient;
import io.orchestrate.client.OrchestrateRequest;
import io.orchestrate.client.Preconditions;
import io.orchestrate.client.Relationship;
import io.orchestrate.client.RelationshipList;
import io.orchestrate.client.RelationshipMetadata;
import io.orchestrate.client.ResponseConverter;
import io.orchestrate.client.ResponseConverterUtil;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import lombok.NonNull;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.memory.ByteBufferWrapper;

public class RelationshipResource
extends BaseResource {
    private String sourceCollection;
    private String sourceKey;
    private String destCollection;
    private String destKey;
    private boolean ifAbsent;
    private String objectRef;
    private boolean invert;
    private int limit;
    private int offset;

    RelationshipResource(OrchestrateClient client, JacksonMapper mapper, String sourceCollection, String sourceKey) {
        super(client, mapper);
        assert (sourceCollection != null);
        assert (sourceKey != null);
        this.sourceCollection = sourceCollection;
        this.sourceKey = sourceKey;
        this.ifAbsent = false;
        this.objectRef = null;
        this.limit = 10;
        this.offset = 0;
    }

    public RelationshipResource ifAbsent() {
        return this.ifAbsent(Boolean.TRUE);
    }

    public RelationshipResource ifAbsent(boolean ifAbsent) {
        Preconditions.checkArgument(!ifAbsent || this.objectRef == null, "'ifMatch' and 'ifAbsent' cannot be used together.");
        this.ifAbsent = ifAbsent;
        return this;
    }

    public RelationshipResource ifMatch(@NonNull String objectRef) {
        if (objectRef == null) {
            throw new NullPointerException("objectRef");
        }
        Preconditions.checkArgument(!this.ifAbsent, "'ifMatch' and 'ifAbsent' cannot be used together.");
        this.objectRef = objectRef;
        return this;
    }

    public <T> OrchestrateRequest<Relationship<T>> get(final Class<T> clazz, final String relation, final String destCollection, final String destKey) {
        Preconditions.checkNotNullOrEmpty(relation, "relation");
        Preconditions.checkNotNullOrEmpty(destCollection, "destCollection");
        Preconditions.checkNotNullOrEmpty(destKey, "destKey");
        String uri = this.client.uri(this.sourceCollection, this.sourceKey, "relation", relation, destCollection, destKey);
        HttpContent packet = HttpRequestPacket.builder().method(Method.GET).uri(uri).build().httpContentBuilder().build();
        return new OrchestrateRequest<Relationship<T>>(this.client, packet, new ResponseConverter<Relationship<T>>(){

            @Override
            public Relationship<T> from(HttpContent response) throws IOException {
                HttpHeader header = response.getHttpHeader();
                int status = ((HttpResponsePacket)header).getStatus();
                assert (status == 200 || status == 404);
                if (status == 404) {
                    return null;
                }
                String ref = header.getHeader(Header.ETag).replace("\"", "").replace("-gzip", "");
                JsonNode valueNode = RelationshipResource.this.toJsonNodeOrNull(response);
                Object value = ResponseConverterUtil.jsonToDomainObject(RelationshipResource.this.mapper, valueNode, clazz);
                String rawValue = null;
                if (value != null && value instanceof String) {
                    rawValue = (String)value;
                }
                Long reftime = null;
                return new Relationship(RelationshipResource.this.mapper, RelationshipResource.this.sourceCollection, RelationshipResource.this.sourceKey, relation, destCollection, destKey, ref, reftime, value, valueNode, rawValue);
            }
        });
    }

    public <T> OrchestrateRequest<RelationshipList<T>> get(final Class<T> clazz, String ... relations) {
        Preconditions.checkNotNull(clazz, "clazz");
        Preconditions.checkArgument(this.destCollection == null && this.destKey == null, "'destCollection' and 'destKey' not valid in GET query.");
        Preconditions.checkNoneEmpty(relations, "relations", "relation");
        final String uri = this.client.uri(this.sourceCollection, this.sourceKey, "relations").concat("/" + this.client.encode(relations));
        String query = "limit=".concat(this.limit + "").concat("&offset=").concat(this.offset + "");
        HttpContent packet = HttpRequestPacket.builder().method(Method.GET).uri(uri).query(query).build().httpContentBuilder().build();
        return new OrchestrateRequest<RelationshipList<T>>(this.client, packet, new ResponseConverter<RelationshipList<T>>(){

            @Override
            public RelationshipList<T> from(HttpContent response) throws IOException {
                int status = ((HttpResponsePacket)response.getHttpHeader()).getStatus();
                assert (status == 200 || status == 404);
                if (status == 404) {
                    return null;
                }
                JsonNode jsonNode = RelationshipResource.this.toJsonNode(response);
                OrchestrateRequest next = RelationshipResource.this.parseLink("next", jsonNode, this);
                if (jsonNode.has("next")) {
                    String page = jsonNode.get("next").asText();
                    URI url = URI.create(page);
                    HttpContent packet = HttpRequestPacket.builder().method(Method.GET).uri(uri).query(url.getQuery()).build().httpContentBuilder().build();
                    next = new OrchestrateRequest(RelationshipResource.this.client, packet, this, false);
                } else {
                    next = null;
                }
                int count = jsonNode.path("count").asInt();
                ArrayList relatedObjects = new ArrayList(count);
                for (JsonNode node : jsonNode.path("results")) {
                    relatedObjects.add(RelationshipResource.this.toKvObject(node, clazz));
                }
                return new RelationshipList(relatedObjects, next);
            }
        });
    }

    public OrchestrateRequest<Boolean> put(String relation) {
        HttpContent packet = this.prepareCreateRelationship(relation, null);
        return new OrchestrateRequest<Boolean>(this.client, packet, new ResponseConverter<Boolean>(){

            @Override
            public Boolean from(HttpContent response) throws IOException {
                HttpHeader header = response.getHttpHeader();
                int status = ((HttpResponsePacket)header).getStatus();
                return status == HttpStatus.CREATED_201.getStatusCode();
            }
        });
    }

    public OrchestrateRequest<RelationshipMetadata> put(final String relation, @NonNull Object properties) {
        if (properties == null) {
            throw new NullPointerException("properties");
        }
        HttpContent packet = this.prepareCreateRelationship(relation, properties);
        return new OrchestrateRequest<RelationshipMetadata>(this.client, packet, new ResponseConverter<RelationshipMetadata>(){

            @Override
            public RelationshipMetadata from(HttpContent response) throws IOException {
                HttpHeader header = response.getHttpHeader();
                int status = ((HttpResponsePacket)header).getStatus();
                if (status == HttpStatus.CREATED_201.getStatusCode()) {
                    String ref = header.getHeader(Header.ETag).replace("\"", "").replace("-gzip", "");
                    Long reftime = null;
                    return new Relationship<Object>(RelationshipResource.this.mapper, RelationshipResource.this.sourceCollection, RelationshipResource.this.sourceKey, relation, RelationshipResource.this.destCollection, RelationshipResource.this.destKey, ref, reftime, null, null, null);
                }
                return null;
            }
        });
    }

    private HttpContent prepareCreateRelationship(String relation, Object properties) {
        Preconditions.checkNotNullOrEmpty(relation, "relation");
        Preconditions.checkArgument(this.destCollection != null && this.destKey != null, "'destCollection' and 'destKey' required for PUT query.");
        String localSourceCollection = this.invert ? this.destCollection : this.sourceCollection;
        String localSourceKey = this.invert ? this.destKey : this.sourceKey;
        String localDestCollection = this.invert ? this.sourceCollection : this.destCollection;
        String localDestKey = this.invert ? this.sourceKey : this.destKey;
        String uri = this.client.uri(localSourceCollection, localSourceKey, "relation", relation, localDestCollection, localDestKey);
        HttpRequestPacket.Builder requestBuilder = ((HttpRequestPacket.Builder)HttpRequestPacket.builder().method(Method.PUT).contentType("application/json")).uri(uri);
        if (this.objectRef != null) {
            requestBuilder.header(Header.IfMatch, "\"".concat(this.objectRef).concat("\""));
        } else if (this.ifAbsent) {
            requestBuilder.header(Header.IfNoneMatch, "\"*\"");
        }
        byte[] content = null;
        if (properties != null) {
            content = this.toJsonBytes(properties);
            requestBuilder.contentLength((long)content.length);
        }
        HttpRequestPacket request = requestBuilder.build();
        HttpContent.Builder httpContentBuilder = request.httpContentBuilder();
        if (properties != null) {
            httpContentBuilder.content((Buffer)new ByteBufferWrapper(ByteBuffer.wrap(content)));
        }
        HttpContent packet = httpContentBuilder.build();
        return packet;
    }

    public OrchestrateRequest<Boolean> purge(String relation) {
        Preconditions.checkNotNullOrEmpty(relation, "relation");
        Preconditions.checkArgument(this.destCollection != null && this.destKey != null, "'destCollection' and 'destKey' required for DELETE query.");
        String localSourceCollection = this.invert ? this.destCollection : this.sourceCollection;
        String localSourceKey = this.invert ? this.destKey : this.sourceKey;
        String localDestCollection = this.invert ? this.sourceCollection : this.destCollection;
        String localDestKey = this.invert ? this.sourceKey : this.destKey;
        String uri = this.client.uri(localSourceCollection, localSourceKey, "relation", relation, localDestCollection, localDestKey);
        HttpContent packet = HttpRequestPacket.builder().method(Method.DELETE).uri(uri).query("purge=true").build().httpContentBuilder().build();
        return new OrchestrateRequest<Boolean>(this.client, packet, new ResponseConverter<Boolean>(){

            @Override
            public Boolean from(HttpContent response) throws IOException {
                int status = ((HttpResponsePacket)response.getHttpHeader()).getStatus();
                return status == HttpStatus.NO_CONTENT_204.getStatusCode();
            }
        });
    }

    public RelationshipResource to(String collection, String key) {
        this.destCollection = Preconditions.checkNotNullOrEmpty(collection, "collection");
        this.destKey = Preconditions.checkNotNullOrEmpty(key, "key");
        return this;
    }

    public RelationshipResource invert() {
        return this.invert(Boolean.TRUE);
    }

    public RelationshipResource invert(boolean invert) {
        this.invert = invert;
        return this;
    }

    public RelationshipResource limit(int limit) {
        this.limit = Preconditions.checkNotNegative(limit, "limit");
        return this;
    }

    public RelationshipResource offset(int offset) {
        this.offset = Preconditions.checkNotNegative(offset, "offset");
        return this;
    }
}

