/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

public class Range {
    private final double min;
    private final double max;

    Range(double min, double max) {
        if (Double.isNaN(min)) {
            throw new IllegalArgumentException("Can't create a Range with NaN min value");
        }
        if (Double.isNaN(max)) {
            throw new IllegalArgumentException("Can't create a Range with NaN max value");
        }
        if (min == max) {
            throw new IllegalArgumentException(String.format("Can't create a Range with identical min and max (%s)", min));
        }
        if (min > max) {
            throw new IllegalArgumentException(String.format("Can't create a Range where min (%s) is greater than max (%s)", min, max));
        }
        this.min = min;
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public static Range below(double max) {
        return new Range(Double.NEGATIVE_INFINITY, max);
    }

    public static Range above(double min) {
        return new Range(min, Double.POSITIVE_INFINITY);
    }

    public static Range between(double min, double max) {
        return new Range(min, max);
    }

    public String unparse() {
        StringBuilder b = new StringBuilder();
        if (this.min == Double.NEGATIVE_INFINITY) {
            b.append('*');
        } else {
            b.append(Double.toString(this.min));
        }
        b.append('~');
        if (this.max == Double.POSITIVE_INFINITY) {
            b.append('*');
        } else {
            b.append(Double.toString(this.max));
        }
        return b.toString();
    }
}

