/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.orchestrate.client.ClientException;
import io.orchestrate.client.ItemKind;
import io.orchestrate.client.KvMetadata;
import io.orchestrate.client.ResponseConverterUtil;
import java.io.IOException;

public class KvObject<T>
implements KvMetadata {
    private final ObjectMapper mapper;
    private final String collection;
    private final String key;
    private final String ref;
    private final Long reftime;
    private final T value;
    private String rawValue;
    private JsonNode valueNode;

    KvObject(String collection, String key, String ref, Long reftime, ObjectMapper mapper, T value, JsonNode valueNode, String rawValue) {
        assert (key != null);
        assert (key.length() > 0);
        assert (ref != null);
        assert (ref.length() > 0);
        this.collection = collection;
        this.key = key;
        this.ref = ref;
        this.reftime = reftime;
        this.mapper = mapper;
        this.value = value;
        this.valueNode = valueNode;
        this.rawValue = rawValue;
    }

    public ItemKind getItemKind() {
        return ItemKind.ITEM;
    }

    public final T getValue() {
        return this.value;
    }

    public <T> T getValue(Class<T> clazz) {
        if (this.valueNode == null) {
            return null;
        }
        if (this.rawValue == null && this.value != null && clazz.equals(String.class)) {
            this.rawValue = (String)this.value;
        }
        try {
            return ResponseConverterUtil.jsonToDomainObject(this.mapper, this.valueNode, this.rawValue, clazz);
        }
        catch (IOException e) {
            throw new ClientException("Could not convert response to JSON.", e);
        }
    }

    public final String getRawValue() {
        if (this.rawValue == null) {
            if (this.valueNode != null) {
                this.rawValue = this.getValue(String.class);
            } else if (this.value != null) {
                try {
                    this.rawValue = this.mapper.writeValueAsString(this.value);
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            }
        }
        return this.rawValue;
    }

    @Override
    public String getCollection() {
        return this.collection;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getRef() {
        return this.ref;
    }

    @Override
    public Long getReftime() {
        return this.reftime;
    }

    public String toString() {
        return "KvObject(mapper=" + this.mapper + ", collection=" + this.getCollection() + ", key=" + this.getKey() + ", ref=" + this.getRef() + ", reftime=" + this.getReftime() + ", value=" + this.getValue() + ", rawValue=" + this.getRawValue() + ", valueNode=" + this.valueNode + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KvObject)) {
            return false;
        }
        KvObject other = (KvObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ObjectMapper this$mapper = this.mapper;
        ObjectMapper other$mapper = other.mapper;
        if (this$mapper == null ? other$mapper != null : !this$mapper.equals(other$mapper)) {
            return false;
        }
        String this$collection = this.getCollection();
        String other$collection = other.getCollection();
        if (this$collection == null ? other$collection != null : !this$collection.equals(other$collection)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$ref = this.getRef();
        String other$ref = other.getRef();
        if (this$ref == null ? other$ref != null : !this$ref.equals(other$ref)) {
            return false;
        }
        Long this$reftime = this.getReftime();
        Long other$reftime = other.getReftime();
        if (this$reftime == null ? other$reftime != null : !((Object)this$reftime).equals(other$reftime)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$rawValue = this.getRawValue();
        String other$rawValue = other.getRawValue();
        if (this$rawValue == null ? other$rawValue != null : !this$rawValue.equals(other$rawValue)) {
            return false;
        }
        JsonNode this$valueNode = this.valueNode;
        JsonNode other$valueNode = other.valueNode;
        return !(this$valueNode == null ? other$valueNode != null : !this$valueNode.equals(other$valueNode));
    }

    public boolean canEqual(Object other) {
        return other instanceof KvObject;
    }

    public int hashCode() {
        int PRIME = 277;
        int result = 1;
        ObjectMapper $mapper = this.mapper;
        result = result * 277 + ($mapper == null ? 0 : $mapper.hashCode());
        String $collection = this.getCollection();
        result = result * 277 + ($collection == null ? 0 : $collection.hashCode());
        String $key = this.getKey();
        result = result * 277 + ($key == null ? 0 : $key.hashCode());
        String $ref = this.getRef();
        result = result * 277 + ($ref == null ? 0 : $ref.hashCode());
        Long $reftime = this.getReftime();
        result = result * 277 + ($reftime == null ? 0 : ((Object)$reftime).hashCode());
        T $value = this.getValue();
        result = result * 277 + ($value == null ? 0 : $value.hashCode());
        String $rawValue = this.getRawValue();
        result = result * 277 + ($rawValue == null ? 0 : $rawValue.hashCode());
        JsonNode $valueNode = this.valueNode;
        result = result * 277 + ($valueNode == null ? 0 : $valueNode.hashCode());
        return result;
    }
}

