/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.orchestrate.client.JacksonMapper;
import io.orchestrate.client.KvObject;
import io.orchestrate.client.OrchestrateClient;
import io.orchestrate.client.OrchestrateRequest;
import io.orchestrate.client.ResponseConverter;
import io.orchestrate.client.ResponseConverterUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.utils.BufferInputStream;

abstract class BaseResource {
    protected final OrchestrateClient client;
    protected final ObjectMapper mapper;
    protected final JacksonMapper jacksonMapper;
    private static final Charset UTF8 = Charset.forName("UTF-8");

    BaseResource(OrchestrateClient client, JacksonMapper mapper) {
        assert (client != null);
        assert (mapper != null);
        this.client = client;
        this.jacksonMapper = mapper;
        this.mapper = mapper.getMapper();
    }

    protected byte[] toJsonBytes(Object value) {
        try {
            return value instanceof String ? ((String)value).getBytes(UTF8) : this.mapper.writeValueAsBytes(value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected JsonNode toJsonNodeOrNull(HttpContent response) throws IOException {
        try {
            return this.mapper.readTree((InputStream)new BufferInputStream(response.getContent()));
        }
        catch (JsonMappingException e) {
            return null;
        }
    }

    protected JsonNode toJsonNode(HttpContent response) throws IOException {
        return this.mapper.readTree((InputStream)new BufferInputStream(response.getContent()));
    }

    protected <T> KvObject<T> toKvObject(JsonNode result, Class<T> clazz) throws IOException {
        return ResponseConverterUtil.wrapperJsonToKvObject(this.mapper, result, clazz);
    }

    protected <T> KvObject<T> toKvObject(HttpContent response, String collection, String key, Class<T> clazz) throws IOException {
        String rawValue = response.getContent().toStringContent();
        String ref = response.getHttpHeader().getHeader(Header.ETag).replace("\"", "").replaceFirst("-gzip$", "");
        return ResponseConverterUtil.jsonToKvObject(this.mapper, rawValue, clazz, collection, key, ref);
    }

    protected <T> OrchestrateRequest<T> parseLink(String name, JsonNode jsonNode, ResponseConverter<T> clazz) {
        OrchestrateRequest<T> next;
        if (jsonNode.has(name)) {
            String page = jsonNode.get(name).asText();
            URI url = URI.create(page);
            HttpContent packet = HttpRequestPacket.builder().method(Method.GET).uri(url.getPath()).query(url.getRawQuery()).build().httpContentBuilder().build();
            next = new OrchestrateRequest<T>(this.client, packet, clazz, false);
        } else {
            next = null;
        }
        return next;
    }
}

