/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client.jsonpatch;

import io.orchestrate.client.jsonpatch.InnerPatchPatchOp;
import io.orchestrate.client.jsonpatch.JsonPatchOp;
import io.orchestrate.client.jsonpatch.TestOp;
import java.util.ArrayList;
import java.util.List;

public class JsonPatch {
    private final List<JsonPatchOp> ops;

    public JsonPatch(List<JsonPatchOp> ops) {
        this.ops = ops;
    }

    public List<JsonPatchOp> getOps() {
        return this.ops;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        List<JsonPatchOp> ops = new ArrayList<JsonPatchOp>();

        public Builder add(String path, Object value) {
            return this.op(new JsonPatchOp("add", path, value));
        }

        public Builder test(String path, Object value) {
            return this.op(TestOp.matches(path, value));
        }

        public Builder testNot(String path, Object value) {
            return this.op(TestOp.notMatches(path, value));
        }

        public Builder testFieldPresent(String path) {
            return this.op(TestOp.fieldPresent(path));
        }

        public Builder testFieldMissing(String path) {
            return this.op(TestOp.fieldMissing(path));
        }

        public Builder move(String from, String path) {
            return this.op(new JsonPatchOp("move", path, null, from));
        }

        public Builder copy(String from, String path) {
            return this.op(new JsonPatchOp("copy", path, null, from));
        }

        public Builder inc(String path) {
            return this.inc(path, null);
        }

        public Builder inc(String path, Number value) {
            return this.op(new JsonPatchOp("inc", path, value));
        }

        public Builder remove(String path) {
            return this.op(new JsonPatchOp("remove", path, null, null));
        }

        public Builder replace(String path, Object value) {
            return this.op(new JsonPatchOp("replace", path, value, null));
        }

        public Builder init(String path, Object value) {
            return this.op(new JsonPatchOp("init", path, value, null));
        }

        public Builder merge(String path, Object value) {
            return this.op(new JsonPatchOp("merge", path, value, null));
        }

        public Builder patch(String path, JsonPatch patch) {
            return this.patch(path, patch, false);
        }

        public Builder patch(String path, Builder patch) {
            return this.patch(path, patch, false);
        }

        public Builder patchIf(String path, Builder patch) {
            return this.patch(path, patch, true);
        }

        public Builder patch(String path, JsonPatch patch, boolean conditional) {
            return this.op(new InnerPatchPatchOp(path, patch, conditional));
        }

        public Builder patch(String path, Builder patch, boolean conditional) {
            return this.patch(path, patch.build(), conditional);
        }

        public Builder op(JsonPatchOp op) {
            this.ops.add(op);
            return this;
        }

        public JsonPatch build() {
            return new JsonPatch(this.ops);
        }
    }
}

