/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.orchestrate.client.AggregateResult;
import io.orchestrate.client.TimeInterval;
import io.orchestrate.client.TimeSeriesBucket;
import java.util.ArrayList;
import java.util.List;

public class TimeSeriesAggregateResult
extends AggregateResult {
    private final TimeInterval interval;
    private final String timeZone;
    private final List<TimeSeriesBucket> buckets;

    TimeSeriesAggregateResult(String fieldName, long valueCount, TimeInterval interval, String timeZone, List<TimeSeriesBucket> buckets) {
        super(fieldName, "time_series", valueCount);
        this.interval = interval;
        this.timeZone = timeZone;
        this.buckets = buckets;
    }

    public TimeInterval getInterval() {
        return this.interval;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public List<TimeSeriesBucket> getBuckets() {
        return this.buckets;
    }

    static TimeSeriesAggregateResult from(JsonNode json) {
        String fieldName = json.get("field_name").asText();
        long valueCount = json.get("value_count").asLong();
        String aggregateKind = json.get("aggregate_kind").asText();
        assert (aggregateKind.equals("time_series"));
        TimeInterval interval = TimeInterval.valueOf(json.get("interval").asText().toUpperCase());
        String timeZone = null;
        if (json.has("time_zone")) {
            timeZone = json.get("time_zone").asText();
        }
        ArrayNode bucketNodes = (ArrayNode)json.get("buckets");
        ArrayList<TimeSeriesBucket> buckets = new ArrayList<TimeSeriesBucket>(bucketNodes.size());
        for (JsonNode bucketNode : bucketNodes) {
            String bucket = bucketNode.get("bucket").asText();
            long count = bucketNode.get("count").asLong();
            buckets.add(new TimeSeriesBucket(bucket, count));
        }
        return new TimeSeriesAggregateResult(fieldName, valueCount, interval, timeZone, buckets);
    }
}

