/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.orchestrate.client.Event;
import io.orchestrate.client.ItemKind;
import io.orchestrate.client.KvObject;
import io.orchestrate.client.Relationship;
import java.io.IOException;

final class ResponseConverterUtil {
    ResponseConverterUtil() {
    }

    static <T> KvObject<T> wrapperJsonToKvObject(ObjectMapper mapper, JsonNode jsonNode, Class<T> clazz) throws IOException {
        assert (mapper != null);
        assert (jsonNode != null);
        assert (clazz != null);
        JsonNode path = jsonNode.get("path");
        String kindText = path.get("kind").asText();
        ItemKind kind = null;
        try {
            kind = ItemKind.fromJson(kindText);
        }
        catch (Exception e) {
            throw new IllegalStateException(String.format("Unknown kind '%s', cannot parse as a KvObject.", kindText));
        }
        if (kind.equals((Object)ItemKind.EVENT)) {
            return ResponseConverterUtil.wrapperJsonToEvent(mapper, jsonNode, clazz);
        }
        if (kind.equals((Object)ItemKind.RELATIONSHIP)) {
            return ResponseConverterUtil.wrapperJsonToRelationship(mapper, jsonNode, clazz);
        }
        String collection = path.get("collection").asText();
        String key = path.get("key").asText();
        String ref = path.get("ref").asText();
        Long reftime = path.has("reftime") ? Long.valueOf(path.get("reftime").longValue()) : null;
        JsonNode valueNode = jsonNode.get("value");
        return ResponseConverterUtil.jsonToKvObject(mapper, valueNode, clazz, collection, key, ref, reftime);
    }

    public static <T> KvObject<T> jsonToKvObject(ObjectMapper mapper, JsonNode valueNode, Class<T> clazz, String collection, String key, String ref) throws IOException {
        return ResponseConverterUtil.jsonToKvObject(mapper, valueNode, clazz, collection, key, ref, null);
    }

    public static <T> KvObject<T> jsonToKvObject(ObjectMapper mapper, JsonNode valueNode, Class<T> clazz, String collection, String key, String ref, Long reftime) throws IOException {
        assert (mapper != null);
        assert (clazz != null);
        T value = ResponseConverterUtil.jsonToDomainObject(mapper, valueNode, clazz);
        String rawValue = null;
        if (value != null && value instanceof String) {
            rawValue = (String)value;
        }
        return new KvObject<T>(collection, key, ref, reftime, mapper, value, valueNode, rawValue);
    }

    public static <T> KvObject<T> jsonToKvObject(ObjectMapper mapper, String rawValue, Class<T> clazz, String collection, String key, String ref) throws IOException {
        assert (mapper != null);
        assert (clazz != null);
        JsonNode valueNode = null;
        if (rawValue != null && !rawValue.isEmpty()) {
            valueNode = mapper.readTree(rawValue);
        }
        T value = ResponseConverterUtil.jsonToDomainObject(mapper, valueNode, rawValue, clazz);
        return new KvObject<T>(collection, key, ref, null, mapper, value, valueNode, rawValue);
    }

    @Deprecated
    public static <T> T jsonToDomainObject(ObjectMapper mapper, String rawValue, Class<T> clazz) throws IOException {
        if (clazz == null || clazz == Void.class || rawValue == null || rawValue.isEmpty()) {
            return null;
        }
        if (clazz.equals(String.class)) {
            return (T)rawValue;
        }
        return (T)mapper.readValue(rawValue, clazz);
    }

    static <T> T jsonToDomainObject(ObjectMapper mapper, JsonNode json, String rawValue, Class<T> clazz) throws IOException {
        if (clazz == null || clazz == Void.class || json == null || json.isNull()) {
            return null;
        }
        if (clazz.equals(String.class)) {
            if (rawValue != null) {
                return (T)rawValue;
            }
            return (T)mapper.writeValueAsString((Object)json);
        }
        return (T)mapper.treeToValue((TreeNode)json, clazz);
    }

    public static <T> T jsonToDomainObject(ObjectMapper mapper, JsonNode json, Class<T> clazz) throws IOException {
        if (clazz == null || clazz == Void.class || json == null || json.isNull()) {
            return null;
        }
        if (clazz.equals(String.class)) {
            return (T)mapper.writeValueAsString((Object)json);
        }
        return (T)mapper.treeToValue((TreeNode)json, clazz);
    }

    public static <T> Event<T> wrapperJsonToEvent(ObjectMapper mapper, JsonNode wrapperJson, Class<T> clazz) throws IOException {
        assert (mapper != null);
        assert (clazz != null);
        JsonNode path = wrapperJson.get("path");
        String collection = path.get("collection").textValue();
        String key = path.get("key").textValue();
        String eventType = path.get("type").textValue();
        String ref = path.get("ref").textValue();
        Long reftime = path.has("reftime") ? Long.valueOf(path.get("reftime").longValue()) : null;
        long timestamp = path.get("timestamp").longValue();
        String ordinal = path.get("ordinal").asText();
        JsonNode valueNode = wrapperJson.get("value");
        T value = ResponseConverterUtil.jsonToDomainObject(mapper, valueNode, clazz);
        String rawValue = null;
        if (value != null && value instanceof String) {
            rawValue = (String)value;
        }
        return new Event<T>(mapper, collection, key, eventType, timestamp, ordinal, ref, reftime, value, valueNode, rawValue);
    }

    public static <T> Relationship<T> wrapperJsonToRelationship(ObjectMapper mapper, JsonNode wrapperJson, Class<T> clazz) throws IOException {
        assert (mapper != null);
        assert (clazz != null);
        JsonNode path = wrapperJson.get("path");
        JsonNode source = path.get("source");
        String sourceCollection = source.get("collection").textValue();
        String sourceKey = source.get("key").textValue();
        String ref = path.get("ref").textValue();
        Long reftime = path.has("reftime") ? Long.valueOf(path.get("reftime").longValue()) : null;
        String relation = path.get("relation").asText();
        JsonNode destination = path.get("destination");
        String destinationCollection = destination.get("collection").asText();
        String destinationKey = destination.get("key").asText();
        JsonNode valueNode = wrapperJson.get("value");
        T value = ResponseConverterUtil.jsonToDomainObject(mapper, valueNode, clazz);
        String rawValue = null;
        if (value != null && value instanceof String) {
            rawValue = (String)value;
        }
        return new Relationship<T>(mapper, sourceCollection, sourceKey, relation, destinationCollection, destinationKey, ref, reftime, value, valueNode, rawValue);
    }
}

