/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.orchestrate.client.ClientException;
import java.util.Map;

public class RequestException
extends ClientException {
    protected static ObjectMapper MAPPER = new ObjectMapper();
    private final int statusCode;
    private final String requestId;
    private final String rawResponse;
    private Map details;
    private String locator;
    private String info;

    RequestException(int statusCode, JsonNode json, String rawResponse, String requestId) {
        super(RequestException.getMessageFromJson(json, rawResponse));
        assert (statusCode >= 0);
        assert (requestId != null);
        assert (requestId.length() > 0);
        this.rawResponse = rawResponse;
        this.statusCode = statusCode;
        this.requestId = requestId;
        if (json != null) {
            if (json.has("details")) {
                try {
                    this.details = (Map)MAPPER.treeToValue((TreeNode)json.get("details"), Map.class);
                    if (this.details.containsKey("info")) {
                        this.info = (String)this.details.get("info");
                    }
                }
                catch (JsonProcessingException ignored) {
                    // empty catch block
                }
            }
            if (json.has("locator")) {
                this.locator = json.get("locator").textValue();
            }
        }
    }

    private static String getMessageFromJson(JsonNode node, String rawResponse) {
        if (node == null) {
            return rawResponse;
        }
        if (node.has("message")) {
            return node.get("message").asText();
        }
        return rawResponse;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public Map getDetails() {
        return this.details;
    }

    public String getLocator() {
        return this.locator;
    }

    public String getRawResponse() {
        return this.rawResponse;
    }

    public String getInfo() {
        return this.info;
    }

    @Override
    public String toString() {
        return "RequestException(statusCode=" + this.getStatusCode() + ", requestId=" + this.getRequestId() + ", rawResponse=" + this.getRawResponse() + ", details=" + this.getDetails() + ", locator=" + this.getLocator() + ", info=" + this.getInfo() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestException)) {
            return false;
        }
        RequestException other = (RequestException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatusCode() != other.getStatusCode()) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$rawResponse = this.getRawResponse();
        String other$rawResponse = other.getRawResponse();
        if (this$rawResponse == null ? other$rawResponse != null : !this$rawResponse.equals(other$rawResponse)) {
            return false;
        }
        Map this$details = this.getDetails();
        Map other$details = other.getDetails();
        if (this$details == null ? other$details != null : !((Object)this$details).equals(other$details)) {
            return false;
        }
        String this$locator = this.getLocator();
        String other$locator = other.getLocator();
        if (this$locator == null ? other$locator != null : !this$locator.equals(other$locator)) {
            return false;
        }
        String this$info = this.getInfo();
        String other$info = other.getInfo();
        return !(this$info == null ? other$info != null : !this$info.equals(other$info));
    }

    public boolean canEqual(Object other) {
        return other instanceof RequestException;
    }

    public int hashCode() {
        int PRIME = 277;
        int result = 1;
        result = result * 277 + this.getStatusCode();
        String $requestId = this.getRequestId();
        result = result * 277 + ($requestId == null ? 0 : $requestId.hashCode());
        String $rawResponse = this.getRawResponse();
        result = result * 277 + ($rawResponse == null ? 0 : $rawResponse.hashCode());
        Map $details = this.getDetails();
        result = result * 277 + ($details == null ? 0 : ((Object)$details).hashCode());
        String $locator = this.getLocator();
        result = result * 277 + ($locator == null ? 0 : $locator.hashCode());
        String $info = this.getInfo();
        result = result * 277 + ($info == null ? 0 : $info.hashCode());
        return result;
    }
}

