/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import io.orchestrate.client.ClientException;
import io.orchestrate.client.ConnectionCompletionHandler;
import io.orchestrate.client.OrchestrateClient;
import io.orchestrate.client.Preconditions;
import io.orchestrate.client.ResponseCompletionHandler;
import io.orchestrate.client.ResponseConverter;
import io.orchestrate.client.ResponseListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.GrizzlyFuture;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.impl.SafeFutureImpl;

public final class OrchestrateRequest<T>
implements Future<T> {
    public static final int DEFAULT_TIMEOUT = 2500;
    private final SafeFutureImpl<HttpContent> rawResponseFuture;
    private final SafeFutureImpl<T> convertedResponseFuture;
    private final OrchestrateClient client;
    private final HttpContent httpRequest;
    private GrizzlyFuture activeRequest;
    private final Semaphore sent = new Semaphore(1);

    OrchestrateRequest(OrchestrateClient client, HttpContent httpRequest, ResponseConverter<T> converter) {
        this(client, httpRequest, converter, true);
    }

    OrchestrateRequest(OrchestrateClient client, HttpContent httpRequest, final ResponseConverter<T> converter, boolean sendImmediate) {
        assert (client != null);
        assert (httpRequest != null);
        assert (converter != null);
        this.client = client;
        this.httpRequest = httpRequest;
        this.rawResponseFuture = SafeFutureImpl.create();
        this.convertedResponseFuture = SafeFutureImpl.create();
        this.rawResponseFuture.addCompletionHandler((CompletionHandler)new CompletionHandler<HttpContent>(){

            public void cancelled() {
                OrchestrateRequest.this.convertedResponseFuture.cancel(false);
            }

            public void failed(Throwable throwable) {
                OrchestrateRequest.this.convertedResponseFuture.failure(throwable);
            }

            public void completed(HttpContent result) {
                try {
                    OrchestrateRequest.this.convertedResponseFuture.result(converter.from(result));
                }
                catch (Exception e) {
                    this.failed(e);
                }
            }

            public void updated(HttpContent result) {
            }
        });
        if (sendImmediate) {
            this.send();
        }
    }

    public OrchestrateRequest<T> on(@NonNull Iterable<ResponseListener<T>> listeners) {
        if (listeners == null) {
            throw new NullPointerException("listeners");
        }
        for (ResponseListener<T> listener : listeners) {
            this.convertedResponseFuture.addCompletionHandler(new ResponseCompletionHandler<T>(listener));
        }
        return this;
    }

    public OrchestrateRequest<T> on(@NonNull ResponseListener<T> listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        this.convertedResponseFuture.addCompletionHandler(new ResponseCompletionHandler<T>(listener));
        return this;
    }

    public OrchestrateRequest<T> getAsync() {
        this.send();
        return this;
    }

    public boolean hasSent() {
        return this.sent.availablePermits() == 0;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.activeRequest != null) {
            this.activeRequest.cancel(mayInterruptIfRunning);
        }
        return this.convertedResponseFuture.cancel(mayInterruptIfRunning);
    }

    @Override
    public boolean isCancelled() {
        return this.convertedResponseFuture.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.convertedResponseFuture.isDone();
    }

    @Override
    public T get() {
        return this.get(2500L, TimeUnit.MILLISECONDS);
    }

    @Override
    public T get(long timeout, TimeUnit unit) {
        Preconditions.checkNotNegative(timeout, "timeout");
        this.send();
        try {
            return (T)this.convertedResponseFuture.get(timeout, unit);
        }
        catch (ClientException ex) {
            throw ex;
        }
        catch (ExecutionException ex) {
            if (ex.getCause() instanceof ClientException) {
                throw (ClientException)ex.getCause();
            }
            throw new ClientException(ex.getCause());
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
    }

    private void send() {
        if (this.sent.tryAcquire()) {
            this.client.execute(this.httpRequest, new ConnectionCompletionHandler(this, this.httpRequest));
        }
    }

    void failed(Throwable t) {
        this.convertedResponseFuture.failure(t);
    }

    void setActiveRequest(GrizzlyFuture activeRequest) {
        this.activeRequest = activeRequest;
    }

    SafeFutureImpl<HttpContent> getRawResponseFuture() {
        return this.rawResponseFuture;
    }
}

