/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.databind.JsonNode;
import io.orchestrate.client.BaseResource;
import io.orchestrate.client.JacksonMapper;
import io.orchestrate.client.KvList;
import io.orchestrate.client.OrchestrateClient;
import io.orchestrate.client.OrchestrateRequest;
import io.orchestrate.client.Preconditions;
import io.orchestrate.client.ResponseConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;

public class KvListResource
extends BaseResource {
    private final String collection;
    @Nullable
    private String startKey;
    private boolean startInclusive;
    @Nullable
    private String stopKey;
    private boolean stopInclusive;
    private int limit;
    private boolean withValues;

    KvListResource(OrchestrateClient client, JacksonMapper mapper, String collection) {
        super(client, mapper);
        assert (collection != null);
        assert (collection.length() > 0);
        this.collection = collection;
        this.startInclusive = false;
        this.stopInclusive = false;
        this.limit = 10;
        this.withValues = true;
    }

    public <T> OrchestrateRequest<KvList<T>> get(final @NonNull Class<T> clazz) {
        String keyName;
        if (clazz == null) {
            throw new NullPointerException("clazz");
        }
        Preconditions.checkArgument(!this.startInclusive || this.startKey != null, "'startInclusive' requires 'startKey' for request.");
        Preconditions.checkArgument(!this.stopInclusive || this.stopKey != null, "'stopInclusive' requires 'stopKey' for request.");
        String uri = this.client.uri(this.collection);
        String query = "limit=".concat(Integer.toString(this.limit));
        query = query.concat("&values=").concat(Boolean.toString(this.withValues));
        if (this.startKey != null) {
            keyName = this.startInclusive ? "startKey" : "afterKey";
            query = query.concat('&' + keyName + '=').concat(this.client.encode(this.startKey));
        }
        if (this.stopKey != null) {
            keyName = this.stopInclusive ? "endKey" : "beforeKey";
            query = query.concat('&' + keyName + '=').concat(this.client.encode(this.stopKey));
        }
        HttpContent packet = HttpRequestPacket.builder().method(Method.GET).uri(uri).query(query).build().httpContentBuilder().build();
        return new OrchestrateRequest<KvList<T>>(this.client, packet, new ResponseConverter<KvList<T>>(){

            @Override
            public KvList<T> from(HttpContent response) throws IOException {
                int status = ((HttpResponsePacket)response.getHttpHeader()).getStatus();
                assert (status == 200);
                JsonNode jsonNode = KvListResource.this.toJsonNode(response);
                OrchestrateRequest next = KvListResource.this.parseLink("next", jsonNode, this);
                int count = jsonNode.get("count").asInt();
                ArrayList results = new ArrayList(count);
                Iterator iter = jsonNode.get("results").elements();
                while (iter.hasNext()) {
                    results.add(KvListResource.this.toKvObject((JsonNode)iter.next(), clazz));
                }
                return new KvList(results, count, next);
            }
        });
    }

    public KvListResource inclusive() {
        return this.inclusive(Boolean.TRUE);
    }

    public KvListResource inclusive(boolean inclusive) {
        this.startInclusive = inclusive;
        return this;
    }

    public KvListResource limit(int limit) {
        this.limit = Preconditions.checkNotNegative(limit, "limit");
        return this;
    }

    public KvListResource startKey(String startKey) {
        this.startKey(startKey, false);
        return this;
    }

    public KvListResource startKey(String startKey, boolean inclusive) {
        this.startKey = Preconditions.checkNotNullOrEmpty(startKey, "startKey");
        this.startInclusive = inclusive;
        return this;
    }

    public KvListResource stopKey(String stopKey) {
        this.stopKey(stopKey, false);
        return this;
    }

    public KvListResource stopKey(String stopKey, boolean inclusive) {
        this.stopKey = Preconditions.checkNotNullOrEmpty(stopKey, "stopKey");
        this.stopInclusive = inclusive;
        return this;
    }

    public KvListResource withValues(boolean withValues) {
        this.withValues = withValues;
        return this;
    }
}

