/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.orchestrate.client.AggregateResult;
import io.orchestrate.client.RangeBucket;
import java.util.ArrayList;
import java.util.List;

public class DistanceAggregateResult
extends AggregateResult {
    private final List<RangeBucket> buckets;

    DistanceAggregateResult(String fieldName, long valueCount, List<RangeBucket> buckets) {
        super(fieldName, "distance", valueCount);
        this.buckets = buckets;
    }

    public List<RangeBucket> getBuckets() {
        return this.buckets;
    }

    static DistanceAggregateResult from(JsonNode json) {
        String fieldName = json.get("field_name").asText();
        long valueCount = json.get("value_count").asLong();
        String aggregateKind = json.get("aggregate_kind").asText();
        assert (aggregateKind.equals("distance"));
        ArrayNode bucketNodes = (ArrayNode)json.get("buckets");
        ArrayList<RangeBucket> buckets = new ArrayList<RangeBucket>(bucketNodes.size());
        for (JsonNode bucketNode : bucketNodes) {
            double min = 0.0;
            if (bucketNode.has("min")) {
                min = bucketNode.get("min").asDouble();
            }
            double max = Double.POSITIVE_INFINITY;
            if (bucketNode.has("max")) {
                max = bucketNode.get("max").asDouble();
            }
            long count = bucketNode.get("count").asLong();
            buckets.add(new RangeBucket(min, max, count));
        }
        return new DistanceAggregateResult(fieldName, valueCount, buckets);
    }
}

