/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import io.orchestrate.client.BaseSearchResource;
import io.orchestrate.client.JacksonMapper;
import io.orchestrate.client.OrchestrateClient;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class CrossCollectionSearchResource
extends BaseSearchResource {
    private Set<String> collections = new HashSet<String>();

    CrossCollectionSearchResource(OrchestrateClient client, JacksonMapper mapper) {
        super(client, mapper);
    }

    @Override
    protected String makeTargetUri() {
        return this.client.uri(new String[0]);
    }

    @Override
    protected String decorateUserQuery(String userQuery) {
        if (this.collections.isEmpty()) {
            return userQuery;
        }
        StringBuilder verbatimCollections = new StringBuilder();
        for (String collection : this.collections) {
            if (verbatimCollections.length() > 0) {
                verbatimCollections.append(' ');
            }
            verbatimCollections.append('`');
            verbatimCollections.append(collection);
            verbatimCollections.append('`');
        }
        return String.format("@path.collection:(%s) AND (%s)", verbatimCollections, userQuery);
    }

    public CrossCollectionSearchResource collections(String ... collections) {
        this.collections.addAll(Arrays.asList(collections));
        return this;
    }
}

