/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.orchestrate.client.AggregateResult;
import io.orchestrate.client.BaseResource;
import io.orchestrate.client.ItemKind;
import io.orchestrate.client.JacksonMapper;
import io.orchestrate.client.KvObject;
import io.orchestrate.client.OrchestrateClient;
import io.orchestrate.client.OrchestrateRequest;
import io.orchestrate.client.Preconditions;
import io.orchestrate.client.ResponseConverter;
import io.orchestrate.client.Result;
import io.orchestrate.client.SearchResults;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;

public abstract class BaseSearchResource
extends BaseResource {
    private static final String QUERY_WITH_KIND = "@path.kind:(%s) AND (%s)";
    private int limit = 10;
    private int offset = 0;
    private boolean withValues = true;
    private String sortFields = null;
    private String aggregateFields = null;
    private String kinds = null;

    BaseSearchResource(OrchestrateClient client, JacksonMapper mapper) {
        super(client, mapper);
    }

    protected abstract String makeTargetUri();

    protected abstract String decorateUserQuery(String var1);

    public OrchestrateRequest<SearchResults<Void>> get(String luceneQuery) {
        return this.get(Void.class, luceneQuery);
    }

    public <T> OrchestrateRequest<SearchResults<T>> get(final Class<T> clazz, String luceneQuery) {
        Preconditions.checkNotNull(clazz, "clazz");
        Preconditions.checkNotNullOrEmpty(luceneQuery, "luceneQuery");
        luceneQuery = this.decorateUserQuery(luceneQuery);
        StringBuilder buff = new StringBuilder("query=");
        if (this.kinds != null) {
            buff.append(this.client.encode(String.format(QUERY_WITH_KIND, this.kinds, luceneQuery)));
        } else {
            buff.append(this.client.encode(luceneQuery));
        }
        buff.append("&limit=").append(this.limit).append("&offset=").append(this.offset).append("&values=").append(Boolean.toString(this.withValues));
        if (this.sortFields != null) {
            buff.append("&sort=").append(this.client.encode(this.sortFields));
        }
        if (this.aggregateFields != null) {
            buff.append("&aggregate=").append(this.client.encode(this.aggregateFields));
        }
        String uri = this.makeTargetUri();
        HttpContent packet = HttpRequestPacket.builder().method(Method.GET).uri(uri).query(buff.toString()).build().httpContentBuilder().build();
        return new OrchestrateRequest<SearchResults<T>>(this.client, packet, new ResponseConverter<SearchResults<T>>(){

            @Override
            public SearchResults<T> from(HttpContent response) throws IOException {
                int status = ((HttpResponsePacket)response.getHttpHeader()).getStatus();
                assert (status == 200);
                JsonNode jsonNode = BaseSearchResource.this.toJsonNode(response);
                int totalCount = jsonNode.get("total_count").asInt();
                int count = jsonNode.get("count").asInt();
                ArrayList results = new ArrayList(count);
                List<AggregateResult> aggregates = Collections.emptyList();
                if (jsonNode.has("aggregates")) {
                    aggregates = AggregateResult.from((ArrayNode)jsonNode.get("aggregates"));
                }
                Iterator iter = jsonNode.get("results").elements();
                while (iter.hasNext()) {
                    JsonNode result = (JsonNode)iter.next();
                    double score = result.get("score") != null ? result.get("score").asDouble(0.0) : 0.0;
                    Double distance = result.get("distance") != null ? Double.valueOf(result.get("distance").asDouble(0.0)) : null;
                    KvObject kvObject = BaseSearchResource.this.toKvObject(result, clazz);
                    results.add(new Result(kvObject, score, distance));
                }
                OrchestrateRequest next = BaseSearchResource.this.parseLink("next", jsonNode, this);
                OrchestrateRequest prev = BaseSearchResource.this.parseLink("prev", jsonNode, this);
                return new SearchResults(results, totalCount, aggregates, next, prev);
            }
        });
    }

    public BaseSearchResource limit(int limit) {
        this.limit = Preconditions.checkNotNegative(limit, "limit");
        return this;
    }

    public BaseSearchResource offset(int offset) {
        this.offset = Preconditions.checkNotNegative(offset, "offset");
        return this;
    }

    public BaseSearchResource sort(String sortFields) {
        this.sortFields = Preconditions.checkNotNull(sortFields, "sortFields");
        return this;
    }

    public BaseSearchResource aggregate(String aggregateFields) {
        this.aggregateFields = Preconditions.checkNotNull(aggregateFields, "aggregateFields");
        return this;
    }

    public BaseSearchResource withValues(boolean withValues) {
        this.withValues = withValues;
        return this;
    }

    public BaseSearchResource kinds(ItemKind ... kinds) {
        if (kinds == null || kinds.length == 0) {
            this.kinds = null;
            return this;
        }
        StringBuilder b = new StringBuilder();
        EnumSet<ItemKind> uniqueKinds = EnumSet.noneOf(ItemKind.class);
        for (ItemKind kind : kinds) {
            if (uniqueKinds.contains((Object)kind)) continue;
            uniqueKinds.add(kind);
            if (b.length() > 0) {
                b.append(" ");
            }
            b.append(kind.toString().toLowerCase());
        }
        this.kinds = b.toString();
        return this;
    }
}

