/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.orchestrate.client.DistanceAggregateResult;
import io.orchestrate.client.RangeAggregateResult;
import io.orchestrate.client.StatsAggregateResult;
import io.orchestrate.client.TimeSeriesAggregateResult;
import io.orchestrate.client.TopValuesAggregateResult;
import java.util.ArrayList;
import java.util.List;

public abstract class AggregateResult {
    private final String fieldName;
    private final String aggregateKind;
    private final long valueCount;

    AggregateResult(String fieldName, String aggregateKind, long valueCount) {
        this.fieldName = fieldName;
        this.aggregateKind = aggregateKind;
        this.valueCount = valueCount;
    }

    static List<AggregateResult> from(ArrayNode aggregateNodes) {
        ArrayList<AggregateResult> aggregates = new ArrayList<AggregateResult>(aggregateNodes.size());
        for (JsonNode aggregateNode : aggregateNodes) {
            String aggregateKind = aggregateNode.get("aggregate_kind").asText();
            AggregateResult aggregate = null;
            if (aggregateKind.equals("top_values")) {
                aggregate = TopValuesAggregateResult.from(aggregateNode);
            } else if (aggregateKind.equals("stats")) {
                aggregate = StatsAggregateResult.from(aggregateNode);
            } else if (aggregateKind.equals("range")) {
                aggregate = RangeAggregateResult.from(aggregateNode);
            } else if (aggregateKind.equals("distance")) {
                aggregate = DistanceAggregateResult.from(aggregateNode);
            } else if (aggregateKind.equals("time_series")) {
                aggregate = TimeSeriesAggregateResult.from(aggregateNode);
            } else {
                throw new RuntimeException("Unexpected aggregate kind: " + aggregateKind);
            }
            aggregates.add(aggregate);
        }
        return aggregates;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getAggregateKind() {
        return this.aggregateKind;
    }

    public long getValueCount() {
        return this.valueCount;
    }
}

