/*
 * Decompiled with CFR 0.152.
 */
package io.orchestrate.client;

import io.orchestrate.client.Preconditions;
import io.orchestrate.client.Range;
import io.orchestrate.client.TimeInterval;

public class Aggregate {
    private final StringBuilder b = new StringBuilder();

    private Aggregate() {
    }

    public static Aggregate builder() {
        return new Aggregate();
    }

    public String build() {
        return this.b.toString();
    }

    public Aggregate topValues(String fieldName) {
        Preconditions.checkNotNull(fieldName, "fieldName");
        if (this.b.length() > 0) {
            this.b.append(',');
        }
        this.b.append(String.format("%s:top_values", fieldName));
        return this;
    }

    public Aggregate topValues(String fieldName, int offset, int limit) {
        Preconditions.checkNotNull(fieldName, "fieldName");
        Preconditions.checkNotNegative(offset, "offset");
        Preconditions.checkNotNegative(limit, "limit");
        if (this.b.length() > 0) {
            this.b.append(',');
        }
        this.b.append(String.format("%s:top_values:offset:%s:limit:%s", fieldName, offset, limit));
        return this;
    }

    public Aggregate stats(String fieldName) {
        Preconditions.checkNotNull(fieldName, "fieldName");
        if (this.b.length() > 0) {
            this.b.append(',');
        }
        this.b.append(String.format("%s:stats", fieldName));
        return this;
    }

    public Aggregate range(String fieldName, Range range, Range ... ranges) {
        Preconditions.checkNotNull(fieldName, "fieldName");
        Preconditions.checkNotNull(range, "range");
        if (this.b.length() > 0) {
            this.b.append(',');
        }
        this.b.append(fieldName);
        this.b.append(":range:");
        this.b.append(range.unparse());
        for (Range r : ranges) {
            Preconditions.checkNotNull(r, "ranges");
            this.b.append(':');
            this.b.append(r.unparse());
        }
        return this;
    }

    public Aggregate distance(String fieldName, Range range, Range ... ranges) {
        Preconditions.checkNotNull(fieldName, "fieldName");
        Preconditions.checkNotNull(range, "range");
        if (this.b.length() > 0) {
            this.b.append(',');
        }
        this.b.append(fieldName);
        this.b.append(":distance:");
        this.b.append(range.unparse());
        for (Range r : ranges) {
            Preconditions.checkNotNull(r, "ranges");
            this.b.append(':');
            this.b.append(r.unparse());
        }
        return this;
    }

    public Aggregate timeSeries(String fieldName, TimeInterval interval) {
        return this.timeSeries(fieldName, interval, null);
    }

    public Aggregate timeSeries(String fieldName, TimeInterval interval, String timeZone) {
        Preconditions.checkNotNull(fieldName, "fieldName");
        Preconditions.checkNotNull(interval, "interval");
        if (this.b.length() > 0) {
            this.b.append(',');
        }
        this.b.append(fieldName);
        this.b.append(":time_series:");
        this.b.append(interval.toString().toLowerCase());
        if (timeZone != null) {
            this.b.append(':');
            this.b.append(timeZone);
        }
        return this;
    }
}

