/*
 * Decompiled with CFR 0.152.
 */
package io.opns.otl.metrics.mbean;

import io.opns.otl.metrics.mbean.SpanMXBean;
import java.util.concurrent.atomic.AtomicBoolean;

public class SpanMXBeanImpl
implements SpanMXBean {
    private static final boolean IDLE = false;
    private static final boolean ACTIVE = true;
    private Long totalSpans = 0L;
    private Long maxSpanCreationTime = 0L;
    private Long avgSpanCreationTime = 0L;
    private Long maxSpanDuration = 0L;
    private Long avgSpanDuration = 0L;
    private String maxDurationSpanId = "";
    private Long totalFinishedSpans = 0L;
    private final AtomicBoolean cLock = new AtomicBoolean(false);
    private final AtomicBoolean fLock = new AtomicBoolean(false);

    @Override
    public Long getTotalSpans() {
        return this.totalSpans;
    }

    @Override
    public Long getMaxSpanCreationTime() {
        return this.maxSpanCreationTime;
    }

    @Override
    public Long getAvgSpanCreationTime() {
        return this.avgSpanCreationTime;
    }

    @Override
    public Long getMaxSpanDuration() {
        return this.maxSpanDuration;
    }

    @Override
    public Long getAvgSpanDuration() {
        return this.avgSpanDuration;
    }

    @Override
    public String getMaxDurationSpanId() {
        return this.maxDurationSpanId;
    }

    @Override
    public Long getTotalFinishedSpans() {
        return this.totalFinishedSpans;
    }

    public void setMaxSpanCreationTime(Long maxSpanCreationTime) {
        this.maxSpanCreationTime = maxSpanCreationTime;
    }

    public void setAvgSpanDuration(Long avgSpanDuration) {
        this.avgSpanDuration = avgSpanDuration;
    }

    public void setAvgSpanCreationTime(Long avgSpanCreationTime) {
        this.avgSpanCreationTime = avgSpanCreationTime;
    }

    public void setTotalSpans(Long totalSpans) {
        this.totalSpans = totalSpans;
    }

    public void setMaxSpanDuration(Long maxSpanDuration) {
        this.maxSpanDuration = maxSpanDuration;
    }

    public void setMaxDurationSpanId(String maxDurationSpanId) {
        this.maxDurationSpanId = maxDurationSpanId;
    }

    public void setTotalFinishedSpans(Long totalFinishedSpans) {
        this.totalFinishedSpans = totalFinishedSpans;
    }

    public void updateSpanCreation(Long creationTime) {
        try {
            while (this.cLock.compareAndSet(false, true)) {
            }
            Long l = this.totalSpans;
            this.totalSpans = this.totalSpans + 1L;
            if (creationTime > this.maxSpanCreationTime) {
                this.maxSpanCreationTime = creationTime;
            }
            this.avgSpanCreationTime = (this.avgSpanCreationTime + creationTime) / this.totalSpans;
        }
        finally {
            this.cLock.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSpanFinish(String spanId, Long duration) {
        try {
            while (this.fLock.compareAndSet(false, true)) {
            }
            if (duration > this.maxSpanDuration) {
                this.maxDurationSpanId = spanId;
                this.maxSpanDuration = duration;
            }
            this.avgSpanDuration = (this.avgSpanDuration + duration) / this.totalSpans;
            Long l = this.totalFinishedSpans;
            this.totalFinishedSpans = this.totalFinishedSpans + 1L;
        }
        finally {
            this.fLock.set(false);
        }
    }
}

