/*
 * Decompiled with CFR 0.152.
 */
package io.opns.otl.metrics;

import io.opns.otl.core.metric.EventType;
import io.opns.otl.core.metric.MetricAdapter;
import io.opns.otl.metrics.server.PlatformMBeanServer;
import io.opns.otl.metrics.stats.StatsContainer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class OTLMetricAdapter
implements MetricAdapter {
    private final StatsContainer container = StatsContainer.get();
    private final PlatformMBeanServer server = PlatformMBeanServer.get();
    private final ObjectName SPAN_MBEAN;

    OTLMetricAdapter() {
        try {
            this.SPAN_MBEAN = new ObjectName("io.opns.otl:type=core,name=span");
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateTracerMetric(EventType type, Object arg) {
    }

    public void updateSpanMetric(EventType type, Object arg) {
        if (EventType.SPAN_CREATED == type) {
            this.container.updateNewSpanStatistics((Long)arg);
        } else if (EventType.SPAN_FINISHED == type) {
            Object[] args = (Object[])arg;
            this.container.updateCompletedSpanStatistics((String)args[0], (Long)args[1]);
        }
    }

    public void updateScopeMetric(EventType type, Object arg) {
        if (EventType.SCOPE_ATIVATED == type) {
            this.container.updateActivatedScopeStatistics();
        } else if (EventType.SCOPE_CLOSED == type) {
            this.container.updateClosedScopeStatistics();
        }
    }
}

