/*
 * Decompiled with CFR 0.152.
 */
package io.opns.otl.kafka;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.util.GlobalTracer;
import io.opns.otl.kafka.KafkaMsgContextCarrier;
import io.opns.otl.kafka.KafkaSpanDecorator;
import io.opns.otl.kafka.StandardKafkaSpanDecorator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.producer.ProducerInterceptor;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingProducerInterceptor
implements ProducerInterceptor<Object, Object> {
    private final Logger logger = LoggerFactory.getLogger(TracingProducerInterceptor.class);
    private final Tracer tracer = GlobalTracer.get();
    private final List<KafkaSpanDecorator> decorators = new ArrayList<KafkaSpanDecorator>();

    public TracingProducerInterceptor() {
        this.decorators.add(new StandardKafkaSpanDecorator());
    }

    public void configure(Map<String, ?> config) {
        KafkaSpanDecorator customDecorator = (KafkaSpanDecorator)config.get("kafka.producer.decorator");
        if (customDecorator != null) {
            this.decorators.add(customDecorator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProducerRecord<Object, Object> onSend(ProducerRecord<Object, Object> record) {
        block17: {
            Boolean enableSpan = Boolean.parseBoolean(System.getProperty("kafka.producer.span", "true"));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Value of kafka.producer.span is: " + enableSpan);
            }
            if (enableSpan.booleanValue()) {
                Span span = this.tracer.buildSpan("kafka-send").start();
                try (Scope scope = this.tracer.activateSpan(span);){
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("Created new kafka producer span: {}", (Object)span.context());
                    }
                    this.tracer.inject(span.context(), Format.Builtin.TEXT_MAP_INJECT, (Object)new KafkaMsgContextCarrier(record.headers()));
                    for (KafkaSpanDecorator decorator : this.decorators) {
                        decorator.onSend(record, span);
                    }
                    break block17;
                }
                finally {
                    span.finish();
                }
            }
            Span span = this.tracer.activeSpan();
            if (span != null) {
                this.tracer.inject(span.context(), Format.Builtin.TEXT_MAP_INJECT, (Object)new KafkaMsgContextCarrier(record.headers()));
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Span creation is disabled in kafka producer. Therefore propagating the current contextual info from the span: {}", (Object)span.context().toSpanId());
                }
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace("No Active span exist. Context won't be propagated");
            }
        }
        return record;
    }

    public void onAcknowledgement(RecordMetadata rm, Exception excptn) {
    }

    public void close() {
    }
}

