/*
 * Decompiled with CFR 0.152.
 */
package io.opns.otl.kafka;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.util.GlobalTracer;
import io.opns.otl.kafka.KafkaSpanContextMap;
import io.opns.otl.kafka.KafkaSpanDecorator;
import io.opns.otl.kafka.StandardKafkaSpanDecorator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.clients.consumer.ConsumerInterceptor;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingConsumerInterceptor<K, V>
implements ConsumerInterceptor<K, V> {
    private final Logger logger = LoggerFactory.getLogger(TracingConsumerInterceptor.class);
    private final Tracer tracer = GlobalTracer.get();
    private final List<KafkaSpanDecorator> decorators = new ArrayList<KafkaSpanDecorator>();

    public TracingConsumerInterceptor() {
        this.decorators.add(new StandardKafkaSpanDecorator());
    }

    public void configure(Map<String, ?> map) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConsumerRecords<K, V> onConsume(ConsumerRecords<K, V> records) {
        for (ConsumerRecord record : records) {
            SpanContext context = this.tracer.extract(Format.Builtin.TEXT_MAP_EXTRACT, (Object)new KafkaSpanContextMap(record.headers()));
            if (context != null) {
                Span span = this.tracer.buildSpan("kafka-recieve").addReference("follows_from", context).start();
                try {
                    Scope scope = this.tracer.activateSpan(span);
                    try {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace("Created new kafka consumer span: {}", (Object)span.context());
                        }
                        for (KafkaSpanDecorator decorator : this.decorators) {
                            decorator.onReceive(record, span);
                        }
                        continue;
                    }
                    finally {
                        if (scope != null) {
                            scope.close();
                        }
                        continue;
                    }
                }
                finally {
                    span.finish();
                    continue;
                }
            }
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace("No span context present in the kafka message.");
        }
        return records;
    }

    public void onCommit(Map<TopicPartition, OffsetAndMetadata> map) {
    }

    public void close() {
    }
}

