/*
 * Decompiled with CFR 0.152.
 */
package io.opns.otl.kafka;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import io.opns.otl.kafka.KafkaSpanDecorator;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.producer.ProducerRecord;

public class StandardKafkaSpanDecorator
implements KafkaSpanDecorator {
    public static final String COMPONENT_KAFKA_PRODUCER = "kafka.producer";
    public static final String COMPONENT_KAFKA_CONSUMER = "kafka.consumer";

    @Override
    public void onSend(ProducerRecord<Object, Object> record, Span span) {
        Tags.COMPONENT.set(span, COMPONENT_KAFKA_PRODUCER);
        Tags.MESSAGE_BUS_DESTINATION.set(span, record.topic());
        Tags.SPAN_KIND.set(span, "producer");
        if (record.partition() != null) {
            span.setTag("partition", (Number)record.partition());
        }
    }

    @Override
    public <K, V> void onReceive(ConsumerRecord<K, V> record, Span span) {
        Tags.COMPONENT.set(span, COMPONENT_KAFKA_CONSUMER);
        Tags.MESSAGE_BUS_DESTINATION.set(span, record.topic());
        Tags.SPAN_KIND.set(span, "consumer");
        span.setTag("offset", (Number)record.offset());
        span.setTag("partition", (Number)record.partition());
    }
}

