/*
 * Decompiled with CFR 0.152.
 */
package io.opns.otl.jaxrs.filter;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.util.GlobalTracer;
import io.opns.otl.core.OTLSyncScope;
import io.opns.otl.core.OTLSyncScopeManager;
import io.opns.otl.core.RequestCtxDecorator;
import io.opns.otl.jaxrs.filter.ContainerSpanDecorator;
import io.opns.otl.jaxrs.filter.RequestHeaderCarrier;
import io.opns.otl.util.ObjectCreator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.servlet.ServletContext;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class TracingContainerFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    private final Logger logger = LoggerFactory.getLogger(TracingContainerFilter.class);
    private final Tracer tracer = GlobalTracer.get();
    private final List<RequestCtxDecorator> decorators = new ArrayList<RequestCtxDecorator>();
    private final List<Pattern> skipPatterns = new ArrayList<Pattern>();
    @Resource
    private ServletContext ctx;

    public TracingContainerFilter() {
        this.decorators.add(new ContainerSpanDecorator());
        if (this.ctx != null) {
            String skipPattern;
            String decoratorClass = this.ctx.getInitParameter("DECORATOR");
            if (decoratorClass != null && (decoratorClass = decoratorClass.trim()).length() > 0) {
                this.decorators.add(this.initDecorator(decoratorClass));
            }
            if ((skipPattern = this.ctx.getInitParameter("SKIP_PATTERN")) != null && (skipPattern = skipPattern.trim()).length() > 0) {
                String[] patterns;
                for (String pattern : patterns = skipPattern.split(",")) {
                    this.skipPatterns.add(Pattern.compile(pattern.trim()));
                }
            }
        }
    }

    private ContainerSpanDecorator initDecorator(String decoratorClass) {
        return (ContainerSpanDecorator)ObjectCreator.create((String)decoratorClass);
    }

    public void filter(ContainerRequestContext requestCtx) throws IOException {
        if (!this.isTraceable(requestCtx)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Request with uri [{}] is not traceable", (Object)requestCtx.getUriInfo().getPath());
            }
            return;
        }
        SpanContext context = this.tracer.extract(Format.Builtin.TEXT_MAP_EXTRACT, (Object)new RequestHeaderCarrier(requestCtx));
        Span span = this.tracer.buildSpan(requestCtx.getMethod()).asChildOf(context).start();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("JaxRs Filter created new Span: {}", (Object)span.context());
        }
        for (RequestCtxDecorator decorator : this.decorators) {
            decorator.onRequest((Object)requestCtx, span);
        }
        this.tracer.activateSpan(span);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filter(ContainerRequestContext requestCtx, ContainerResponseContext responseCtx) throws IOException {
        Span span = null;
        try (OTLSyncScope scope = ((OTLSyncScopeManager)this.tracer.scopeManager()).active();){
            span = this.tracer.activeSpan();
            if (span != null) {
                for (RequestCtxDecorator decorator : this.decorators) {
                    decorator.onResponse((Object)requestCtx, (Object)responseCtx, span);
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("JaxRs Filter will finish the Span: {}", (Object)span.context());
                }
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace("JaxRs Filter did not find any active span");
            }
        }
        finally {
            if (span != null) {
                span.finish();
            }
        }
    }

    private boolean isTraceable(ContainerRequestContext requestCtx) {
        if (!this.skipPatterns.isEmpty()) {
            boolean skipped = false;
            String uri = requestCtx.getUriInfo().getPath();
            for (Pattern skipPattern : this.skipPatterns) {
                skipped = skipPattern.matcher(uri).matches();
                if (!skipped) continue;
                return false;
            }
            return true;
        }
        return true;
    }
}

