/*
 * Decompiled with CFR 0.152.
 */
package io.opns.otl.jaxrs.filter;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.util.GlobalTracer;
import io.opns.otl.core.OTLSyncScope;
import io.opns.otl.core.OTLSyncScopeManager;
import io.opns.otl.jaxrs.filter.ClientSpanDecorator;
import io.opns.otl.jaxrs.filter.RequestHeaderAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class TracingClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private final Logger logger = LoggerFactory.getLogger(ClientRequestFilter.class);
    private final Tracer tracer = GlobalTracer.get();
    private final List<ClientSpanDecorator> decorators = new ArrayList<ClientSpanDecorator>();

    public TracingClientFilter() {
        this.decorators.add(new ClientSpanDecorator());
    }

    public void filter(ClientRequestContext requestCtx) throws IOException {
        Boolean enableSpan = Boolean.parseBoolean(System.getProperty("jax.rs.span", "true"));
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Value of jax.rs.span is: " + enableSpan);
        }
        if (enableSpan.booleanValue()) {
            Span span = this.tracer.buildSpan(requestCtx.getMethod()).start();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Created new Jax-rs client span: {}", (Object)span.context());
            }
            this.tracer.inject(span.context(), Format.Builtin.TEXT_MAP_INJECT, (Object)new RequestHeaderAdapter(requestCtx));
            for (ClientSpanDecorator decorator : this.decorators) {
                decorator.onRequest(requestCtx, span);
            }
            this.tracer.activateSpan(span);
        } else {
            Span span = this.tracer.activeSpan();
            if (span != null) {
                this.tracer.inject(span.context(), Format.Builtin.TEXT_MAP_INJECT, (Object)new RequestHeaderAdapter(requestCtx));
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Span creation is disabled in Jax-rs client. Therefore propagating the current contextual info from the span: {}", (Object)span.context().toSpanId());
                }
            } else if (this.logger.isTraceEnabled()) {
                this.logger.trace("No Active span exist. Context won't be propagated");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void filter(ClientRequestContext requestCtx, ClientResponseContext responseCtx) throws IOException {
        Boolean enableSpan = Boolean.parseBoolean(System.getProperty("jax.rs.span", "true"));
        if (enableSpan.booleanValue()) {
            Span span = null;
            try (OTLSyncScope scope = ((OTLSyncScopeManager)this.tracer.scopeManager()).active();){
                span = this.tracer.activeSpan();
                if (span != null) {
                    for (ClientSpanDecorator decorator : this.decorators) {
                        decorator.onResponse(requestCtx, responseCtx, span);
                    }
                    if (!this.logger.isTraceEnabled()) return;
                    this.logger.trace("JaxRs Client Filter will finish the Span: {}", (Object)span.context());
                    return;
                }
                if (!this.logger.isTraceEnabled()) return;
                this.logger.trace("JaxRs Client Filter did not find any active span");
                return;
            }
            finally {
                if (span != null) {
                    span.finish();
                }
            }
        } else {
            if (!this.logger.isTraceEnabled()) return;
            this.logger.trace("Jax-rs Client side span creation is disabled.");
        }
    }
}

