/*
 * Decompiled with CFR 0.152.
 */
package io.opns.otl.jaxrs.filter;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import io.opns.otl.core.RequestCtxDecorator;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;

public class ContainerSpanDecorator
implements RequestCtxDecorator<ContainerRequestContext, ContainerResponseContext> {
    public static final String JAX_RS = "jaxrs.web";

    public void onRequest(ContainerRequestContext requestContext, Span span) {
        Tags.COMPONENT.set(span, JAX_RS);
        Tags.HTTP_METHOD.set(span, requestContext.getMethod());
        Tags.HTTP_URL.set(span, requestContext.getUriInfo().getPath());
        Tags.SPAN_KIND.set(span, "server");
    }

    public void onResponse(ContainerRequestContext requestContext, ContainerResponseContext responseContext, Span span) {
        Tags.HTTP_STATUS.set(span, Integer.valueOf(responseContext.getStatus()));
    }

    public void onError(ContainerRequestContext request, ContainerResponseContext response, Throwable e, Span span) {
        Tags.HTTP_STATUS.set(span, Integer.valueOf(response.getStatus()));
        Tags.ERROR.set(span, Boolean.TRUE);
    }
}

