/*
 * Decompiled with CFR 0.152.
 */
package io.opns.otl.jaxrs.filter;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import io.opns.otl.core.RequestCtxDecorator;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;

public class ClientSpanDecorator
implements RequestCtxDecorator<ClientRequestContext, ClientResponseContext> {
    public static final String JAX_RS_CLIENT = "jaxrs.client";

    public void onRequest(ClientRequestContext requestContext, Span span) {
        Tags.COMPONENT.set(span, JAX_RS_CLIENT);
        Tags.HTTP_METHOD.set(span, requestContext.getMethod());
        Tags.HTTP_URL.set(span, requestContext.getUri().getPath());
        Tags.SPAN_KIND.set(span, "client");
    }

    public void onResponse(ClientRequestContext requestContext, ClientResponseContext responseContext, Span span) {
        Tags.HTTP_STATUS.set(span, Integer.valueOf(responseContext.getStatus()));
    }

    public void onError(ClientRequestContext request, ClientResponseContext response, Throwable e, Span span) {
        Tags.HTTP_STATUS.set(span, Integer.valueOf(response.getStatus()));
        Tags.ERROR.set(span, Boolean.TRUE);
    }
}

