package com.ericsson.research.owr;

import com.ericsson.research.NativeInstance;
import com.ericsson.research.NativePointer;

public class VideoRenderer extends MediaRenderer {
    public VideoRenderer(java.lang.String tag) {
        super(_newNativePointer(0));
        long pointer = nativeConstructor(tag);
        _setInternalPointer(pointer);
    }
    native long nativeConstructor(java.lang.String tag);

    VideoRenderer(NativePointer nativePointer) {
        super(nativePointer);
    }

    public native void setHeight(int height);

    public native int getHeight();

    private java.util.HashMap<HeightChangeListener, Integer> handleMapHeightChangeListener;

    public static interface HeightChangeListener {
        public void onHeightChanged(int height);
    }

    private native int connectHeightChangeListener(com.ericsson.research.owr.VideoRenderer.HeightChangeListener listener);

    private native void disconnectHeightChangeListener(int handle);

    public synchronized void addHeightChangeListener(com.ericsson.research.owr.VideoRenderer.HeightChangeListener listener) {
        if (handleMapHeightChangeListener == null) {
            handleMapHeightChangeListener = new java.util.HashMap<HeightChangeListener, Integer>();
        }

        Integer current = handleMapHeightChangeListener.remove(listener);
        if (current != null) {
            disconnectHeightChangeListener(current);
        }

        int handle = connectHeightChangeListener(listener);
        handleMapHeightChangeListener.put(listener, handle);
    }

    public synchronized void removeHeightChangeListener(com.ericsson.research.owr.VideoRenderer.HeightChangeListener listener) {
        if (handleMapHeightChangeListener == null) {
            handleMapHeightChangeListener = new java.util.HashMap<HeightChangeListener, Integer>();
        }

        Integer current = handleMapHeightChangeListener.remove(listener);
        if (current != null) {
            disconnectHeightChangeListener(current);
        }
    }

    public native void setMaxFramerate(double maxFramerate);

    public native double getMaxFramerate();

    private java.util.HashMap<MaxFramerateChangeListener, Integer> handleMapMaxFramerateChangeListener;

    public static interface MaxFramerateChangeListener {
        public void onMaxFramerateChanged(double maxFramerate);
    }

    private native int connectMaxFramerateChangeListener(com.ericsson.research.owr.VideoRenderer.MaxFramerateChangeListener listener);

    private native void disconnectMaxFramerateChangeListener(int handle);

    public synchronized void addMaxFramerateChangeListener(com.ericsson.research.owr.VideoRenderer.MaxFramerateChangeListener listener) {
        if (handleMapMaxFramerateChangeListener == null) {
            handleMapMaxFramerateChangeListener = new java.util.HashMap<MaxFramerateChangeListener, Integer>();
        }

        Integer current = handleMapMaxFramerateChangeListener.remove(listener);
        if (current != null) {
            disconnectMaxFramerateChangeListener(current);
        }

        int handle = connectMaxFramerateChangeListener(listener);
        handleMapMaxFramerateChangeListener.put(listener, handle);
    }

    public synchronized void removeMaxFramerateChangeListener(com.ericsson.research.owr.VideoRenderer.MaxFramerateChangeListener listener) {
        if (handleMapMaxFramerateChangeListener == null) {
            handleMapMaxFramerateChangeListener = new java.util.HashMap<MaxFramerateChangeListener, Integer>();
        }

        Integer current = handleMapMaxFramerateChangeListener.remove(listener);
        if (current != null) {
            disconnectMaxFramerateChangeListener(current);
        }
    }

    public native void setMirror(boolean mirror);

    public native boolean getMirror();

    private java.util.HashMap<MirrorChangeListener, Integer> handleMapMirrorChangeListener;

    public static interface MirrorChangeListener {
        public void onMirrorChanged(boolean mirror);
    }

    private native int connectMirrorChangeListener(com.ericsson.research.owr.VideoRenderer.MirrorChangeListener listener);

    private native void disconnectMirrorChangeListener(int handle);

    public synchronized void addMirrorChangeListener(com.ericsson.research.owr.VideoRenderer.MirrorChangeListener listener) {
        if (handleMapMirrorChangeListener == null) {
            handleMapMirrorChangeListener = new java.util.HashMap<MirrorChangeListener, Integer>();
        }

        Integer current = handleMapMirrorChangeListener.remove(listener);
        if (current != null) {
            disconnectMirrorChangeListener(current);
        }

        int handle = connectMirrorChangeListener(listener);
        handleMapMirrorChangeListener.put(listener, handle);
    }

    public synchronized void removeMirrorChangeListener(com.ericsson.research.owr.VideoRenderer.MirrorChangeListener listener) {
        if (handleMapMirrorChangeListener == null) {
            handleMapMirrorChangeListener = new java.util.HashMap<MirrorChangeListener, Integer>();
        }

        Integer current = handleMapMirrorChangeListener.remove(listener);
        if (current != null) {
            disconnectMirrorChangeListener(current);
        }
    }

    public native void setRotation(int rotation);

    public native int getRotation();

    private java.util.HashMap<RotationChangeListener, Integer> handleMapRotationChangeListener;

    public static interface RotationChangeListener {
        public void onRotationChanged(int rotation);
    }

    private native int connectRotationChangeListener(com.ericsson.research.owr.VideoRenderer.RotationChangeListener listener);

    private native void disconnectRotationChangeListener(int handle);

    public synchronized void addRotationChangeListener(com.ericsson.research.owr.VideoRenderer.RotationChangeListener listener) {
        if (handleMapRotationChangeListener == null) {
            handleMapRotationChangeListener = new java.util.HashMap<RotationChangeListener, Integer>();
        }

        Integer current = handleMapRotationChangeListener.remove(listener);
        if (current != null) {
            disconnectRotationChangeListener(current);
        }

        int handle = connectRotationChangeListener(listener);
        handleMapRotationChangeListener.put(listener, handle);
    }

    public synchronized void removeRotationChangeListener(com.ericsson.research.owr.VideoRenderer.RotationChangeListener listener) {
        if (handleMapRotationChangeListener == null) {
            handleMapRotationChangeListener = new java.util.HashMap<RotationChangeListener, Integer>();
        }

        Integer current = handleMapRotationChangeListener.remove(listener);
        if (current != null) {
            disconnectRotationChangeListener(current);
        }
    }

    public native java.lang.String getTag();

    private java.util.HashMap<TagChangeListener, Integer> handleMapTagChangeListener;

    public static interface TagChangeListener {
        public void onTagChanged(java.lang.String tag);
    }

    private native int connectTagChangeListener(com.ericsson.research.owr.VideoRenderer.TagChangeListener listener);

    private native void disconnectTagChangeListener(int handle);

    public synchronized void addTagChangeListener(com.ericsson.research.owr.VideoRenderer.TagChangeListener listener) {
        if (handleMapTagChangeListener == null) {
            handleMapTagChangeListener = new java.util.HashMap<TagChangeListener, Integer>();
        }

        Integer current = handleMapTagChangeListener.remove(listener);
        if (current != null) {
            disconnectTagChangeListener(current);
        }

        int handle = connectTagChangeListener(listener);
        handleMapTagChangeListener.put(listener, handle);
    }

    public synchronized void removeTagChangeListener(com.ericsson.research.owr.VideoRenderer.TagChangeListener listener) {
        if (handleMapTagChangeListener == null) {
            handleMapTagChangeListener = new java.util.HashMap<TagChangeListener, Integer>();
        }

        Integer current = handleMapTagChangeListener.remove(listener);
        if (current != null) {
            disconnectTagChangeListener(current);
        }
    }

    public native void setWidth(int width);

    public native int getWidth();

    private java.util.HashMap<WidthChangeListener, Integer> handleMapWidthChangeListener;

    public static interface WidthChangeListener {
        public void onWidthChanged(int width);
    }

    private native int connectWidthChangeListener(com.ericsson.research.owr.VideoRenderer.WidthChangeListener listener);

    private native void disconnectWidthChangeListener(int handle);

    public synchronized void addWidthChangeListener(com.ericsson.research.owr.VideoRenderer.WidthChangeListener listener) {
        if (handleMapWidthChangeListener == null) {
            handleMapWidthChangeListener = new java.util.HashMap<WidthChangeListener, Integer>();
        }

        Integer current = handleMapWidthChangeListener.remove(listener);
        if (current != null) {
            disconnectWidthChangeListener(current);
        }

        int handle = connectWidthChangeListener(listener);
        handleMapWidthChangeListener.put(listener, handle);
    }

    public synchronized void removeWidthChangeListener(com.ericsson.research.owr.VideoRenderer.WidthChangeListener listener) {
        if (handleMapWidthChangeListener == null) {
            handleMapWidthChangeListener = new java.util.HashMap<WidthChangeListener, Integer>();
        }

        Integer current = handleMapWidthChangeListener.remove(listener);
        if (current != null) {
            disconnectWidthChangeListener(current);
        }
    }
}