package com.ericsson.research.owr;

import com.ericsson.research.ValueEnum;

public enum TransportType implements ValueEnum {
    UDP(0, "UDP"),
    TCP_ACTIVE(1, "TCP-active"),
    TCP_PASSIVE(2, "TCP-passive"),
    TCP_SO(3, "TCP-so");

    private final int mValue;
    private final String mNick;

    private TransportType(int value, String nick) {
        mValue = value;
        mNick = nick;
    }

    public int getValue() {
        return mValue;
    }

    public String getNick() {
        return mNick;
    }

    public static TransportType valueOfNick(String nick) {
        if ("UDP".equals(nick)) {
            return UDP;
        } else if ("TCP-active".equals(nick)) {
            return TCP_ACTIVE;
        } else if ("TCP-passive".equals(nick)) {
            return TCP_PASSIVE;
        } else if ("TCP-so".equals(nick)) {
            return TCP_SO;
        } else {
            throw new IllegalArgumentException("Invalid enum nick: " + nick);
        }
    }
}