package com.ericsson.research.owr;

import com.ericsson.research.NativeInstance;
import com.ericsson.research.NativePointer;

public class TransportAgent extends NativeInstance {
    public TransportAgent(boolean ice_controlling_mode) {
        super(_newNativePointer(0));
        long pointer = nativeConstructor(ice_controlling_mode);
        _setInternalPointer(pointer);
    }
    native long nativeConstructor(boolean ice_controlling_mode);

    TransportAgent(NativePointer nativePointer) {
        super(nativePointer);
    }

    /**
     * @param username The helper server username (when applicable)
     * @param password The helper server password (when applicable)
     * @param type The type of helper server to add
     * @param port The port on the helper server
     * @param address The IP address or hostname of the helper server
     */
    public native void addHelperServer(com.ericsson.research.owr.HelperServerType type, java.lang.String address, int port, java.lang.String username, java.lang.String password);

    public native void addLocalAddress(java.lang.String local_address);

    public native void addSession(com.ericsson.research.owr.Session session);

    public native java.lang.String getDotData();

    public native void setLocalPortRange(int min_port, int max_port);

    public native void setIceControllingMode(boolean iceControllingMode);

    public native boolean getIceControllingMode();

    private java.util.HashMap<IceControllingModeChangeListener, Integer> handleMapIceControllingModeChangeListener;

    public static interface IceControllingModeChangeListener {
        public void onIceControllingModeChanged(boolean iceControllingMode);
    }

    private native int connectIceControllingModeChangeListener(com.ericsson.research.owr.TransportAgent.IceControllingModeChangeListener listener);

    private native void disconnectIceControllingModeChangeListener(int handle);

    public synchronized void addIceControllingModeChangeListener(com.ericsson.research.owr.TransportAgent.IceControllingModeChangeListener listener) {
        if (handleMapIceControllingModeChangeListener == null) {
            handleMapIceControllingModeChangeListener = new java.util.HashMap<IceControllingModeChangeListener, Integer>();
        }

        Integer current = handleMapIceControllingModeChangeListener.remove(listener);
        if (current != null) {
            disconnectIceControllingModeChangeListener(current);
        }

        int handle = connectIceControllingModeChangeListener(listener);
        handleMapIceControllingModeChangeListener.put(listener, handle);
    }

    public synchronized void removeIceControllingModeChangeListener(com.ericsson.research.owr.TransportAgent.IceControllingModeChangeListener listener) {
        if (handleMapIceControllingModeChangeListener == null) {
            handleMapIceControllingModeChangeListener = new java.util.HashMap<IceControllingModeChangeListener, Integer>();
        }

        Integer current = handleMapIceControllingModeChangeListener.remove(listener);
        if (current != null) {
            disconnectIceControllingModeChangeListener(current);
        }
    }
}