package com.ericsson.research.owr;

import com.ericsson.research.ValueEnum;

public enum SourceType implements ValueEnum {
    UNKNOWN(0, "unknown"),
    CAPTURE(1, "capture"),
    TEST(2, "test");

    private final int mValue;
    private final String mNick;

    private SourceType(int value, String nick) {
        mValue = value;
        mNick = nick;
    }

    public int getValue() {
        return mValue;
    }

    public String getNick() {
        return mNick;
    }

    public static SourceType valueOfNick(String nick) {
        if ("unknown".equals(nick)) {
            return UNKNOWN;
        } else if ("capture".equals(nick)) {
            return CAPTURE;
        } else if ("test".equals(nick)) {
            return TEST;
        } else {
            throw new IllegalArgumentException("Invalid enum nick: " + nick);
        }
    }
}