package com.ericsson.research.owr;

import com.ericsson.research.NativeInstance;
import com.ericsson.research.NativePointer;

public class Session extends NativeInstance {
    Session(NativePointer nativePointer) {
        super(nativePointer);
    }

    /**
     * Adds a remote candidate for this session.
     * @param candidate the candidate to add
     */
    public native void addRemoteCandidate(com.ericsson.research.owr.Candidate candidate);

    /**
     * Forces the transport agent to use the given candidate. Calling this function will disable all further ICE processing. Keep-alives will continue to be sent.
     * @param candidate the candidate to forcibly set
     */
    public native void forceRemoteCandidate(com.ericsson.research.owr.Candidate candidate);

    public native void setDtlsCertificate(java.lang.String dtlsCertificate);

    public native java.lang.String getDtlsCertificate();

    private java.util.HashMap<DtlsCertificateChangeListener, Integer> handleMapDtlsCertificateChangeListener;

    public static interface DtlsCertificateChangeListener {
        public void onDtlsCertificateChanged(java.lang.String dtlsCertificate);
    }

    private native int connectDtlsCertificateChangeListener(com.ericsson.research.owr.Session.DtlsCertificateChangeListener listener);

    private native void disconnectDtlsCertificateChangeListener(int handle);

    public synchronized void addDtlsCertificateChangeListener(com.ericsson.research.owr.Session.DtlsCertificateChangeListener listener) {
        if (handleMapDtlsCertificateChangeListener == null) {
            handleMapDtlsCertificateChangeListener = new java.util.HashMap<DtlsCertificateChangeListener, Integer>();
        }

        Integer current = handleMapDtlsCertificateChangeListener.remove(listener);
        if (current != null) {
            disconnectDtlsCertificateChangeListener(current);
        }

        int handle = connectDtlsCertificateChangeListener(listener);
        handleMapDtlsCertificateChangeListener.put(listener, handle);
    }

    public synchronized void removeDtlsCertificateChangeListener(com.ericsson.research.owr.Session.DtlsCertificateChangeListener listener) {
        if (handleMapDtlsCertificateChangeListener == null) {
            handleMapDtlsCertificateChangeListener = new java.util.HashMap<DtlsCertificateChangeListener, Integer>();
        }

        Integer current = handleMapDtlsCertificateChangeListener.remove(listener);
        if (current != null) {
            disconnectDtlsCertificateChangeListener(current);
        }
    }

    public native boolean getDtlsClientMode();

    private java.util.HashMap<DtlsClientModeChangeListener, Integer> handleMapDtlsClientModeChangeListener;

    public static interface DtlsClientModeChangeListener {
        public void onDtlsClientModeChanged(boolean dtlsClientMode);
    }

    private native int connectDtlsClientModeChangeListener(com.ericsson.research.owr.Session.DtlsClientModeChangeListener listener);

    private native void disconnectDtlsClientModeChangeListener(int handle);

    public synchronized void addDtlsClientModeChangeListener(com.ericsson.research.owr.Session.DtlsClientModeChangeListener listener) {
        if (handleMapDtlsClientModeChangeListener == null) {
            handleMapDtlsClientModeChangeListener = new java.util.HashMap<DtlsClientModeChangeListener, Integer>();
        }

        Integer current = handleMapDtlsClientModeChangeListener.remove(listener);
        if (current != null) {
            disconnectDtlsClientModeChangeListener(current);
        }

        int handle = connectDtlsClientModeChangeListener(listener);
        handleMapDtlsClientModeChangeListener.put(listener, handle);
    }

    public synchronized void removeDtlsClientModeChangeListener(com.ericsson.research.owr.Session.DtlsClientModeChangeListener listener) {
        if (handleMapDtlsClientModeChangeListener == null) {
            handleMapDtlsClientModeChangeListener = new java.util.HashMap<DtlsClientModeChangeListener, Integer>();
        }

        Integer current = handleMapDtlsClientModeChangeListener.remove(listener);
        if (current != null) {
            disconnectDtlsClientModeChangeListener(current);
        }
    }

    public native void setDtlsKey(java.lang.String dtlsKey);

    public native java.lang.String getDtlsKey();

    private java.util.HashMap<DtlsKeyChangeListener, Integer> handleMapDtlsKeyChangeListener;

    public static interface DtlsKeyChangeListener {
        public void onDtlsKeyChanged(java.lang.String dtlsKey);
    }

    private native int connectDtlsKeyChangeListener(com.ericsson.research.owr.Session.DtlsKeyChangeListener listener);

    private native void disconnectDtlsKeyChangeListener(int handle);

    public synchronized void addDtlsKeyChangeListener(com.ericsson.research.owr.Session.DtlsKeyChangeListener listener) {
        if (handleMapDtlsKeyChangeListener == null) {
            handleMapDtlsKeyChangeListener = new java.util.HashMap<DtlsKeyChangeListener, Integer>();
        }

        Integer current = handleMapDtlsKeyChangeListener.remove(listener);
        if (current != null) {
            disconnectDtlsKeyChangeListener(current);
        }

        int handle = connectDtlsKeyChangeListener(listener);
        handleMapDtlsKeyChangeListener.put(listener, handle);
    }

    public synchronized void removeDtlsKeyChangeListener(com.ericsson.research.owr.Session.DtlsKeyChangeListener listener) {
        if (handleMapDtlsKeyChangeListener == null) {
            handleMapDtlsKeyChangeListener = new java.util.HashMap<DtlsKeyChangeListener, Integer>();
        }

        Integer current = handleMapDtlsKeyChangeListener.remove(listener);
        if (current != null) {
            disconnectDtlsKeyChangeListener(current);
        }
    }

    public native java.lang.String getDtlsPeerCertificate();

    private java.util.HashMap<DtlsPeerCertificateChangeListener, Integer> handleMapDtlsPeerCertificateChangeListener;

    public static interface DtlsPeerCertificateChangeListener {
        public void onDtlsPeerCertificateChanged(java.lang.String dtlsPeerCertificate);
    }

    private native int connectDtlsPeerCertificateChangeListener(com.ericsson.research.owr.Session.DtlsPeerCertificateChangeListener listener);

    private native void disconnectDtlsPeerCertificateChangeListener(int handle);

    public synchronized void addDtlsPeerCertificateChangeListener(com.ericsson.research.owr.Session.DtlsPeerCertificateChangeListener listener) {
        if (handleMapDtlsPeerCertificateChangeListener == null) {
            handleMapDtlsPeerCertificateChangeListener = new java.util.HashMap<DtlsPeerCertificateChangeListener, Integer>();
        }

        Integer current = handleMapDtlsPeerCertificateChangeListener.remove(listener);
        if (current != null) {
            disconnectDtlsPeerCertificateChangeListener(current);
        }

        int handle = connectDtlsPeerCertificateChangeListener(listener);
        handleMapDtlsPeerCertificateChangeListener.put(listener, handle);
    }

    public synchronized void removeDtlsPeerCertificateChangeListener(com.ericsson.research.owr.Session.DtlsPeerCertificateChangeListener listener) {
        if (handleMapDtlsPeerCertificateChangeListener == null) {
            handleMapDtlsPeerCertificateChangeListener = new java.util.HashMap<DtlsPeerCertificateChangeListener, Integer>();
        }

        Integer current = handleMapDtlsPeerCertificateChangeListener.remove(listener);
        if (current != null) {
            disconnectDtlsPeerCertificateChangeListener(current);
        }
    }

    public native com.ericsson.research.owr.IceState getIceConnectionState();

    private java.util.HashMap<IceConnectionStateChangeListener, Integer> handleMapIceConnectionStateChangeListener;

    public static interface IceConnectionStateChangeListener {
        public void onIceConnectionStateChanged(com.ericsson.research.owr.IceState iceConnectionState);
    }

    private native int connectIceConnectionStateChangeListener(com.ericsson.research.owr.Session.IceConnectionStateChangeListener listener);

    private native void disconnectIceConnectionStateChangeListener(int handle);

    public synchronized void addIceConnectionStateChangeListener(com.ericsson.research.owr.Session.IceConnectionStateChangeListener listener) {
        if (handleMapIceConnectionStateChangeListener == null) {
            handleMapIceConnectionStateChangeListener = new java.util.HashMap<IceConnectionStateChangeListener, Integer>();
        }

        Integer current = handleMapIceConnectionStateChangeListener.remove(listener);
        if (current != null) {
            disconnectIceConnectionStateChangeListener(current);
        }

        int handle = connectIceConnectionStateChangeListener(listener);
        handleMapIceConnectionStateChangeListener.put(listener, handle);
    }

    public synchronized void removeIceConnectionStateChangeListener(com.ericsson.research.owr.Session.IceConnectionStateChangeListener listener) {
        if (handleMapIceConnectionStateChangeListener == null) {
            handleMapIceConnectionStateChangeListener = new java.util.HashMap<IceConnectionStateChangeListener, Integer>();
        }

        Integer current = handleMapIceConnectionStateChangeListener.remove(listener);
        if (current != null) {
            disconnectIceConnectionStateChangeListener(current);
        }
    }

    private java.util.HashMap<OnCandidateGatheringDoneListener, Integer> handleMapOnCandidateGatheringDoneListener;

    public static interface OnCandidateGatheringDoneListener {
        public void onCandidateGatheringDone();
    }

    private native int connectOnCandidateGatheringDoneListener(com.ericsson.research.owr.Session.OnCandidateGatheringDoneListener listener);

    private native void disconnectOnCandidateGatheringDoneListener(int handle);

    public synchronized void addOnCandidateGatheringDoneListener(com.ericsson.research.owr.Session.OnCandidateGatheringDoneListener listener) {
        if (handleMapOnCandidateGatheringDoneListener == null) {
            handleMapOnCandidateGatheringDoneListener = new java.util.HashMap<OnCandidateGatheringDoneListener, Integer>();
        }

        Integer current = handleMapOnCandidateGatheringDoneListener.remove(listener);
        if (current != null) {
            disconnectOnCandidateGatheringDoneListener(current);
        }

        int handle = connectOnCandidateGatheringDoneListener(listener);
        handleMapOnCandidateGatheringDoneListener.put(listener, handle);
    }

    public synchronized void removeOnCandidateGatheringDoneListener(com.ericsson.research.owr.Session.OnCandidateGatheringDoneListener listener) {
        if (handleMapOnCandidateGatheringDoneListener == null) {
            handleMapOnCandidateGatheringDoneListener = new java.util.HashMap<OnCandidateGatheringDoneListener, Integer>();
        }

        Integer current = handleMapOnCandidateGatheringDoneListener.remove(listener);
        if (current != null) {
            disconnectOnCandidateGatheringDoneListener(current);
        }
    }

    private java.util.HashMap<OnNewCandidateListener, Integer> handleMapOnNewCandidateListener;

    public static interface OnNewCandidateListener {
        /**
         * @param candidate the candidate gathered
         */
        public void onNewCandidate(com.ericsson.research.owr.Candidate candidate);
    }

    private native int connectOnNewCandidateListener(com.ericsson.research.owr.Session.OnNewCandidateListener listener);

    private native void disconnectOnNewCandidateListener(int handle);

    public synchronized void addOnNewCandidateListener(com.ericsson.research.owr.Session.OnNewCandidateListener listener) {
        if (handleMapOnNewCandidateListener == null) {
            handleMapOnNewCandidateListener = new java.util.HashMap<OnNewCandidateListener, Integer>();
        }

        Integer current = handleMapOnNewCandidateListener.remove(listener);
        if (current != null) {
            disconnectOnNewCandidateListener(current);
        }

        int handle = connectOnNewCandidateListener(listener);
        handleMapOnNewCandidateListener.put(listener, handle);
    }

    public synchronized void removeOnNewCandidateListener(com.ericsson.research.owr.Session.OnNewCandidateListener listener) {
        if (handleMapOnNewCandidateListener == null) {
            handleMapOnNewCandidateListener = new java.util.HashMap<OnNewCandidateListener, Integer>();
        }

        Integer current = handleMapOnNewCandidateListener.remove(listener);
        if (current != null) {
            disconnectOnNewCandidateListener(current);
        }
    }
}