package com.ericsson.research.owr;

import com.ericsson.research.ValueEnum;

public enum MediaType implements ValueEnum {
    UNKNOWN(0, "unknown"),
    AUDIO(1, "audio"),
    VIDEO(2, "video");

    private final int mValue;
    private final String mNick;

    private MediaType(int value, String nick) {
        mValue = value;
        mNick = nick;
    }

    public int getValue() {
        return mValue;
    }

    public String getNick() {
        return mNick;
    }

    public static MediaType valueOfNick(String nick) {
        if ("unknown".equals(nick)) {
            return UNKNOWN;
        } else if ("audio".equals(nick)) {
            return AUDIO;
        } else if ("video".equals(nick)) {
            return VIDEO;
        } else {
            throw new IllegalArgumentException("Invalid enum nick: " + nick);
        }
    }
}