package com.ericsson.research.owr;

import com.ericsson.research.NativeInstance;
import com.ericsson.research.NativePointer;

public class MediaSource extends NativeInstance {
    MediaSource(NativePointer nativePointer) {
        super(nativePointer);
    }

    public native java.lang.String getDotData();

    public native java.util.EnumSet<com.ericsson.research.owr.MediaType> getMediaType();

    private java.util.HashMap<MediaTypeChangeListener, Integer> handleMapMediaTypeChangeListener;

    public static interface MediaTypeChangeListener {
        public void onMediaTypeChanged(java.util.EnumSet<com.ericsson.research.owr.MediaType> mediaType);
    }

    private native int connectMediaTypeChangeListener(com.ericsson.research.owr.MediaSource.MediaTypeChangeListener listener);

    private native void disconnectMediaTypeChangeListener(int handle);

    public synchronized void addMediaTypeChangeListener(com.ericsson.research.owr.MediaSource.MediaTypeChangeListener listener) {
        if (handleMapMediaTypeChangeListener == null) {
            handleMapMediaTypeChangeListener = new java.util.HashMap<MediaTypeChangeListener, Integer>();
        }

        Integer current = handleMapMediaTypeChangeListener.remove(listener);
        if (current != null) {
            disconnectMediaTypeChangeListener(current);
        }

        int handle = connectMediaTypeChangeListener(listener);
        handleMapMediaTypeChangeListener.put(listener, handle);
    }

    public synchronized void removeMediaTypeChangeListener(com.ericsson.research.owr.MediaSource.MediaTypeChangeListener listener) {
        if (handleMapMediaTypeChangeListener == null) {
            handleMapMediaTypeChangeListener = new java.util.HashMap<MediaTypeChangeListener, Integer>();
        }

        Integer current = handleMapMediaTypeChangeListener.remove(listener);
        if (current != null) {
            disconnectMediaTypeChangeListener(current);
        }
    }

    public native java.lang.String getName();

    private java.util.HashMap<NameChangeListener, Integer> handleMapNameChangeListener;

    public static interface NameChangeListener {
        public void onNameChanged(java.lang.String name);
    }

    private native int connectNameChangeListener(com.ericsson.research.owr.MediaSource.NameChangeListener listener);

    private native void disconnectNameChangeListener(int handle);

    public synchronized void addNameChangeListener(com.ericsson.research.owr.MediaSource.NameChangeListener listener) {
        if (handleMapNameChangeListener == null) {
            handleMapNameChangeListener = new java.util.HashMap<NameChangeListener, Integer>();
        }

        Integer current = handleMapNameChangeListener.remove(listener);
        if (current != null) {
            disconnectNameChangeListener(current);
        }

        int handle = connectNameChangeListener(listener);
        handleMapNameChangeListener.put(listener, handle);
    }

    public synchronized void removeNameChangeListener(com.ericsson.research.owr.MediaSource.NameChangeListener listener) {
        if (handleMapNameChangeListener == null) {
            handleMapNameChangeListener = new java.util.HashMap<NameChangeListener, Integer>();
        }

        Integer current = handleMapNameChangeListener.remove(listener);
        if (current != null) {
            disconnectNameChangeListener(current);
        }
    }

    public native com.ericsson.research.owr.SourceType getType();

    private java.util.HashMap<TypeChangeListener, Integer> handleMapTypeChangeListener;

    public static interface TypeChangeListener {
        public void onTypeChanged(com.ericsson.research.owr.SourceType type);
    }

    private native int connectTypeChangeListener(com.ericsson.research.owr.MediaSource.TypeChangeListener listener);

    private native void disconnectTypeChangeListener(int handle);

    public synchronized void addTypeChangeListener(com.ericsson.research.owr.MediaSource.TypeChangeListener listener) {
        if (handleMapTypeChangeListener == null) {
            handleMapTypeChangeListener = new java.util.HashMap<TypeChangeListener, Integer>();
        }

        Integer current = handleMapTypeChangeListener.remove(listener);
        if (current != null) {
            disconnectTypeChangeListener(current);
        }

        int handle = connectTypeChangeListener(listener);
        handleMapTypeChangeListener.put(listener, handle);
    }

    public synchronized void removeTypeChangeListener(com.ericsson.research.owr.MediaSource.TypeChangeListener listener) {
        if (handleMapTypeChangeListener == null) {
            handleMapTypeChangeListener = new java.util.HashMap<TypeChangeListener, Integer>();
        }

        Integer current = handleMapTypeChangeListener.remove(listener);
        if (current != null) {
            disconnectTypeChangeListener(current);
        }
    }
}