package com.ericsson.research.owr;

import com.ericsson.research.NativeInstance;
import com.ericsson.research.NativePointer;

public class MediaSession extends Session {
    public MediaSession(boolean dtls_client_mode) {
        super(_newNativePointer(0));
        long pointer = nativeConstructor(dtls_client_mode);
        _setInternalPointer(pointer);
    }
    native long nativeConstructor(boolean dtls_client_mode);

    MediaSession(NativePointer nativePointer) {
        super(nativePointer);
    }

    /**
     * The function adds support for receiving the given payload type.
     * @param payload the receive payload to add
     */
    public native void addReceivePayload(com.ericsson.research.owr.Payload payload);

    /**
     * Sets what payload that will be sent.
     * @param payload the send payload to set
     */
    public native void setSendPayload(com.ericsson.research.owr.Payload payload);

    /**
     * Sets the source from which data will be sent.
     * @param source the send source to set
     */
    public native void setSendSource(com.ericsson.research.owr.MediaSource source);

    public native java.lang.String getCname();

    private java.util.HashMap<CnameChangeListener, Integer> handleMapCnameChangeListener;

    public static interface CnameChangeListener {
        public void onCnameChanged(java.lang.String cname);
    }

    private native int connectCnameChangeListener(com.ericsson.research.owr.MediaSession.CnameChangeListener listener);

    private native void disconnectCnameChangeListener(int handle);

    public synchronized void addCnameChangeListener(com.ericsson.research.owr.MediaSession.CnameChangeListener listener) {
        if (handleMapCnameChangeListener == null) {
            handleMapCnameChangeListener = new java.util.HashMap<CnameChangeListener, Integer>();
        }

        Integer current = handleMapCnameChangeListener.remove(listener);
        if (current != null) {
            disconnectCnameChangeListener(current);
        }

        int handle = connectCnameChangeListener(listener);
        handleMapCnameChangeListener.put(listener, handle);
    }

    public synchronized void removeCnameChangeListener(com.ericsson.research.owr.MediaSession.CnameChangeListener listener) {
        if (handleMapCnameChangeListener == null) {
            handleMapCnameChangeListener = new java.util.HashMap<CnameChangeListener, Integer>();
        }

        Integer current = handleMapCnameChangeListener.remove(listener);
        if (current != null) {
            disconnectCnameChangeListener(current);
        }
    }

    public native void setIncomingSrtpKey(java.lang.String incomingSrtpKey);

    public native java.lang.String getIncomingSrtpKey();

    private java.util.HashMap<IncomingSrtpKeyChangeListener, Integer> handleMapIncomingSrtpKeyChangeListener;

    public static interface IncomingSrtpKeyChangeListener {
        public void onIncomingSrtpKeyChanged(java.lang.String incomingSrtpKey);
    }

    private native int connectIncomingSrtpKeyChangeListener(com.ericsson.research.owr.MediaSession.IncomingSrtpKeyChangeListener listener);

    private native void disconnectIncomingSrtpKeyChangeListener(int handle);

    public synchronized void addIncomingSrtpKeyChangeListener(com.ericsson.research.owr.MediaSession.IncomingSrtpKeyChangeListener listener) {
        if (handleMapIncomingSrtpKeyChangeListener == null) {
            handleMapIncomingSrtpKeyChangeListener = new java.util.HashMap<IncomingSrtpKeyChangeListener, Integer>();
        }

        Integer current = handleMapIncomingSrtpKeyChangeListener.remove(listener);
        if (current != null) {
            disconnectIncomingSrtpKeyChangeListener(current);
        }

        int handle = connectIncomingSrtpKeyChangeListener(listener);
        handleMapIncomingSrtpKeyChangeListener.put(listener, handle);
    }

    public synchronized void removeIncomingSrtpKeyChangeListener(com.ericsson.research.owr.MediaSession.IncomingSrtpKeyChangeListener listener) {
        if (handleMapIncomingSrtpKeyChangeListener == null) {
            handleMapIncomingSrtpKeyChangeListener = new java.util.HashMap<IncomingSrtpKeyChangeListener, Integer>();
        }

        Integer current = handleMapIncomingSrtpKeyChangeListener.remove(listener);
        if (current != null) {
            disconnectIncomingSrtpKeyChangeListener(current);
        }
    }

    public native void setJitterBufferLatency(int jitterBufferLatency);

    public native int getJitterBufferLatency();

    private java.util.HashMap<JitterBufferLatencyChangeListener, Integer> handleMapJitterBufferLatencyChangeListener;

    public static interface JitterBufferLatencyChangeListener {
        public void onJitterBufferLatencyChanged(int jitterBufferLatency);
    }

    private native int connectJitterBufferLatencyChangeListener(com.ericsson.research.owr.MediaSession.JitterBufferLatencyChangeListener listener);

    private native void disconnectJitterBufferLatencyChangeListener(int handle);

    public synchronized void addJitterBufferLatencyChangeListener(com.ericsson.research.owr.MediaSession.JitterBufferLatencyChangeListener listener) {
        if (handleMapJitterBufferLatencyChangeListener == null) {
            handleMapJitterBufferLatencyChangeListener = new java.util.HashMap<JitterBufferLatencyChangeListener, Integer>();
        }

        Integer current = handleMapJitterBufferLatencyChangeListener.remove(listener);
        if (current != null) {
            disconnectJitterBufferLatencyChangeListener(current);
        }

        int handle = connectJitterBufferLatencyChangeListener(listener);
        handleMapJitterBufferLatencyChangeListener.put(listener, handle);
    }

    public synchronized void removeJitterBufferLatencyChangeListener(com.ericsson.research.owr.MediaSession.JitterBufferLatencyChangeListener listener) {
        if (handleMapJitterBufferLatencyChangeListener == null) {
            handleMapJitterBufferLatencyChangeListener = new java.util.HashMap<JitterBufferLatencyChangeListener, Integer>();
        }

        Integer current = handleMapJitterBufferLatencyChangeListener.remove(listener);
        if (current != null) {
            disconnectJitterBufferLatencyChangeListener(current);
        }
    }

    public native void setOutgoingSrtpKey(java.lang.String outgoingSrtpKey);

    public native java.lang.String getOutgoingSrtpKey();

    private java.util.HashMap<OutgoingSrtpKeyChangeListener, Integer> handleMapOutgoingSrtpKeyChangeListener;

    public static interface OutgoingSrtpKeyChangeListener {
        public void onOutgoingSrtpKeyChanged(java.lang.String outgoingSrtpKey);
    }

    private native int connectOutgoingSrtpKeyChangeListener(com.ericsson.research.owr.MediaSession.OutgoingSrtpKeyChangeListener listener);

    private native void disconnectOutgoingSrtpKeyChangeListener(int handle);

    public synchronized void addOutgoingSrtpKeyChangeListener(com.ericsson.research.owr.MediaSession.OutgoingSrtpKeyChangeListener listener) {
        if (handleMapOutgoingSrtpKeyChangeListener == null) {
            handleMapOutgoingSrtpKeyChangeListener = new java.util.HashMap<OutgoingSrtpKeyChangeListener, Integer>();
        }

        Integer current = handleMapOutgoingSrtpKeyChangeListener.remove(listener);
        if (current != null) {
            disconnectOutgoingSrtpKeyChangeListener(current);
        }

        int handle = connectOutgoingSrtpKeyChangeListener(listener);
        handleMapOutgoingSrtpKeyChangeListener.put(listener, handle);
    }

    public synchronized void removeOutgoingSrtpKeyChangeListener(com.ericsson.research.owr.MediaSession.OutgoingSrtpKeyChangeListener listener) {
        if (handleMapOutgoingSrtpKeyChangeListener == null) {
            handleMapOutgoingSrtpKeyChangeListener = new java.util.HashMap<OutgoingSrtpKeyChangeListener, Integer>();
        }

        Integer current = handleMapOutgoingSrtpKeyChangeListener.remove(listener);
        if (current != null) {
            disconnectOutgoingSrtpKeyChangeListener(current);
        }
    }

    public native void setRtcpMux(boolean rtcpMux);

    public native boolean getRtcpMux();

    private java.util.HashMap<RtcpMuxChangeListener, Integer> handleMapRtcpMuxChangeListener;

    public static interface RtcpMuxChangeListener {
        public void onRtcpMuxChanged(boolean rtcpMux);
    }

    private native int connectRtcpMuxChangeListener(com.ericsson.research.owr.MediaSession.RtcpMuxChangeListener listener);

    private native void disconnectRtcpMuxChangeListener(int handle);

    public synchronized void addRtcpMuxChangeListener(com.ericsson.research.owr.MediaSession.RtcpMuxChangeListener listener) {
        if (handleMapRtcpMuxChangeListener == null) {
            handleMapRtcpMuxChangeListener = new java.util.HashMap<RtcpMuxChangeListener, Integer>();
        }

        Integer current = handleMapRtcpMuxChangeListener.remove(listener);
        if (current != null) {
            disconnectRtcpMuxChangeListener(current);
        }

        int handle = connectRtcpMuxChangeListener(listener);
        handleMapRtcpMuxChangeListener.put(listener, handle);
    }

    public synchronized void removeRtcpMuxChangeListener(com.ericsson.research.owr.MediaSession.RtcpMuxChangeListener listener) {
        if (handleMapRtcpMuxChangeListener == null) {
            handleMapRtcpMuxChangeListener = new java.util.HashMap<RtcpMuxChangeListener, Integer>();
        }

        Integer current = handleMapRtcpMuxChangeListener.remove(listener);
        if (current != null) {
            disconnectRtcpMuxChangeListener(current);
        }
    }

    public native int getSendSsrc();

    private java.util.HashMap<SendSsrcChangeListener, Integer> handleMapSendSsrcChangeListener;

    public static interface SendSsrcChangeListener {
        public void onSendSsrcChanged(int sendSsrc);
    }

    private native int connectSendSsrcChangeListener(com.ericsson.research.owr.MediaSession.SendSsrcChangeListener listener);

    private native void disconnectSendSsrcChangeListener(int handle);

    public synchronized void addSendSsrcChangeListener(com.ericsson.research.owr.MediaSession.SendSsrcChangeListener listener) {
        if (handleMapSendSsrcChangeListener == null) {
            handleMapSendSsrcChangeListener = new java.util.HashMap<SendSsrcChangeListener, Integer>();
        }

        Integer current = handleMapSendSsrcChangeListener.remove(listener);
        if (current != null) {
            disconnectSendSsrcChangeListener(current);
        }

        int handle = connectSendSsrcChangeListener(listener);
        handleMapSendSsrcChangeListener.put(listener, handle);
    }

    public synchronized void removeSendSsrcChangeListener(com.ericsson.research.owr.MediaSession.SendSsrcChangeListener listener) {
        if (handleMapSendSsrcChangeListener == null) {
            handleMapSendSsrcChangeListener = new java.util.HashMap<SendSsrcChangeListener, Integer>();
        }

        Integer current = handleMapSendSsrcChangeListener.remove(listener);
        if (current != null) {
            disconnectSendSsrcChangeListener(current);
        }
    }

    private java.util.HashMap<OnIncomingSourceListener, Integer> handleMapOnIncomingSourceListener;

    public static interface OnIncomingSourceListener {
        /**
         * @param source the new incoming source
         */
        public void onIncomingSource(com.ericsson.research.owr.RemoteMediaSource source);
    }

    private native int connectOnIncomingSourceListener(com.ericsson.research.owr.MediaSession.OnIncomingSourceListener listener);

    private native void disconnectOnIncomingSourceListener(int handle);

    public synchronized void addOnIncomingSourceListener(com.ericsson.research.owr.MediaSession.OnIncomingSourceListener listener) {
        if (handleMapOnIncomingSourceListener == null) {
            handleMapOnIncomingSourceListener = new java.util.HashMap<OnIncomingSourceListener, Integer>();
        }

        Integer current = handleMapOnIncomingSourceListener.remove(listener);
        if (current != null) {
            disconnectOnIncomingSourceListener(current);
        }

        int handle = connectOnIncomingSourceListener(listener);
        handleMapOnIncomingSourceListener.put(listener, handle);
    }

    public synchronized void removeOnIncomingSourceListener(com.ericsson.research.owr.MediaSession.OnIncomingSourceListener listener) {
        if (handleMapOnIncomingSourceListener == null) {
            handleMapOnIncomingSourceListener = new java.util.HashMap<OnIncomingSourceListener, Integer>();
        }

        Integer current = handleMapOnIncomingSourceListener.remove(listener);
        if (current != null) {
            disconnectOnIncomingSourceListener(current);
        }
    }

    private java.util.HashMap<OnNewStatsListener, Integer> handleMapOnNewStatsListener;

    public static interface OnNewStatsListener {
        /**
         * @param stats the stats #GHashTable
         */
        public void onNewStats(java.util.HashMap<java.lang.String, java.lang.Object> stats);
    }

    private native int connectOnNewStatsListener(com.ericsson.research.owr.MediaSession.OnNewStatsListener listener);

    private native void disconnectOnNewStatsListener(int handle);

    public synchronized void addOnNewStatsListener(com.ericsson.research.owr.MediaSession.OnNewStatsListener listener) {
        if (handleMapOnNewStatsListener == null) {
            handleMapOnNewStatsListener = new java.util.HashMap<OnNewStatsListener, Integer>();
        }

        Integer current = handleMapOnNewStatsListener.remove(listener);
        if (current != null) {
            disconnectOnNewStatsListener(current);
        }

        int handle = connectOnNewStatsListener(listener);
        handleMapOnNewStatsListener.put(listener, handle);
    }

    public synchronized void removeOnNewStatsListener(com.ericsson.research.owr.MediaSession.OnNewStatsListener listener) {
        if (handleMapOnNewStatsListener == null) {
            handleMapOnNewStatsListener = new java.util.HashMap<OnNewStatsListener, Integer>();
        }

        Integer current = handleMapOnNewStatsListener.remove(listener);
        if (current != null) {
            disconnectOnNewStatsListener(current);
        }
    }
}