package com.ericsson.research.owr;

import com.ericsson.research.NativeInstance;
import com.ericsson.research.NativePointer;

public class MediaRenderer extends NativeInstance {
    MediaRenderer(NativePointer nativePointer) {
        super(nativePointer);
    }

    public native java.lang.String getDotData();

    public native void setSource(com.ericsson.research.owr.MediaSource source);

    public native void setDisabled(boolean disabled);

    public native boolean getDisabled();

    private java.util.HashMap<DisabledChangeListener, Integer> handleMapDisabledChangeListener;

    public static interface DisabledChangeListener {
        public void onDisabledChanged(boolean disabled);
    }

    private native int connectDisabledChangeListener(com.ericsson.research.owr.MediaRenderer.DisabledChangeListener listener);

    private native void disconnectDisabledChangeListener(int handle);

    public synchronized void addDisabledChangeListener(com.ericsson.research.owr.MediaRenderer.DisabledChangeListener listener) {
        if (handleMapDisabledChangeListener == null) {
            handleMapDisabledChangeListener = new java.util.HashMap<DisabledChangeListener, Integer>();
        }

        Integer current = handleMapDisabledChangeListener.remove(listener);
        if (current != null) {
            disconnectDisabledChangeListener(current);
        }

        int handle = connectDisabledChangeListener(listener);
        handleMapDisabledChangeListener.put(listener, handle);
    }

    public synchronized void removeDisabledChangeListener(com.ericsson.research.owr.MediaRenderer.DisabledChangeListener listener) {
        if (handleMapDisabledChangeListener == null) {
            handleMapDisabledChangeListener = new java.util.HashMap<DisabledChangeListener, Integer>();
        }

        Integer current = handleMapDisabledChangeListener.remove(listener);
        if (current != null) {
            disconnectDisabledChangeListener(current);
        }
    }

    public native java.util.EnumSet<com.ericsson.research.owr.MediaType> getMediaType();

    private java.util.HashMap<MediaTypeChangeListener, Integer> handleMapMediaTypeChangeListener;

    public static interface MediaTypeChangeListener {
        public void onMediaTypeChanged(java.util.EnumSet<com.ericsson.research.owr.MediaType> mediaType);
    }

    private native int connectMediaTypeChangeListener(com.ericsson.research.owr.MediaRenderer.MediaTypeChangeListener listener);

    private native void disconnectMediaTypeChangeListener(int handle);

    public synchronized void addMediaTypeChangeListener(com.ericsson.research.owr.MediaRenderer.MediaTypeChangeListener listener) {
        if (handleMapMediaTypeChangeListener == null) {
            handleMapMediaTypeChangeListener = new java.util.HashMap<MediaTypeChangeListener, Integer>();
        }

        Integer current = handleMapMediaTypeChangeListener.remove(listener);
        if (current != null) {
            disconnectMediaTypeChangeListener(current);
        }

        int handle = connectMediaTypeChangeListener(listener);
        handleMapMediaTypeChangeListener.put(listener, handle);
    }

    public synchronized void removeMediaTypeChangeListener(com.ericsson.research.owr.MediaRenderer.MediaTypeChangeListener listener) {
        if (handleMapMediaTypeChangeListener == null) {
            handleMapMediaTypeChangeListener = new java.util.HashMap<MediaTypeChangeListener, Integer>();
        }

        Integer current = handleMapMediaTypeChangeListener.remove(listener);
        if (current != null) {
            disconnectMediaTypeChangeListener(current);
        }
    }
}