package com.ericsson.research.owr;

import com.ericsson.research.NativeInstance;
import com.ericsson.research.NativePointer;

public class LocalMediaSource extends MediaSource {
    LocalMediaSource(NativePointer nativePointer) {
        super(nativePointer);
    }

    public native void setDeviceIndex(int deviceIndex);

    public native int getDeviceIndex();

    private java.util.HashMap<DeviceIndexChangeListener, Integer> handleMapDeviceIndexChangeListener;

    public static interface DeviceIndexChangeListener {
        public void onDeviceIndexChanged(int deviceIndex);
    }

    private native int connectDeviceIndexChangeListener(com.ericsson.research.owr.LocalMediaSource.DeviceIndexChangeListener listener);

    private native void disconnectDeviceIndexChangeListener(int handle);

    public synchronized void addDeviceIndexChangeListener(com.ericsson.research.owr.LocalMediaSource.DeviceIndexChangeListener listener) {
        if (handleMapDeviceIndexChangeListener == null) {
            handleMapDeviceIndexChangeListener = new java.util.HashMap<DeviceIndexChangeListener, Integer>();
        }

        Integer current = handleMapDeviceIndexChangeListener.remove(listener);
        if (current != null) {
            disconnectDeviceIndexChangeListener(current);
        }

        int handle = connectDeviceIndexChangeListener(listener);
        handleMapDeviceIndexChangeListener.put(listener, handle);
    }

    public synchronized void removeDeviceIndexChangeListener(com.ericsson.research.owr.LocalMediaSource.DeviceIndexChangeListener listener) {
        if (handleMapDeviceIndexChangeListener == null) {
            handleMapDeviceIndexChangeListener = new java.util.HashMap<DeviceIndexChangeListener, Integer>();
        }

        Integer current = handleMapDeviceIndexChangeListener.remove(listener);
        if (current != null) {
            disconnectDeviceIndexChangeListener(current);
        }
    }
}