package com.ericsson.research.owr;

import com.ericsson.research.NativeInstance;
import com.ericsson.research.NativePointer;

public class ImageServer extends NativeInstance {
    public ImageServer(int port) {
        super(_newNativePointer(0));
        long pointer = nativeConstructor(port);
        _setInternalPointer(pointer);
    }
    native long nativeConstructor(int port);

    ImageServer(NativePointer nativePointer) {
        super(nativePointer);
    }

    public native void addImageRenderer(com.ericsson.research.owr.ImageRenderer image_renderer, java.lang.String tag);

    public native void removeImageRenderer(java.lang.String tag);

    public native void setAllowOrigin(java.lang.String allowOrigin);

    public native java.lang.String getAllowOrigin();

    private java.util.HashMap<AllowOriginChangeListener, Integer> handleMapAllowOriginChangeListener;

    public static interface AllowOriginChangeListener {
        public void onAllowOriginChanged(java.lang.String allowOrigin);
    }

    private native int connectAllowOriginChangeListener(com.ericsson.research.owr.ImageServer.AllowOriginChangeListener listener);

    private native void disconnectAllowOriginChangeListener(int handle);

    public synchronized void addAllowOriginChangeListener(com.ericsson.research.owr.ImageServer.AllowOriginChangeListener listener) {
        if (handleMapAllowOriginChangeListener == null) {
            handleMapAllowOriginChangeListener = new java.util.HashMap<AllowOriginChangeListener, Integer>();
        }

        Integer current = handleMapAllowOriginChangeListener.remove(listener);
        if (current != null) {
            disconnectAllowOriginChangeListener(current);
        }

        int handle = connectAllowOriginChangeListener(listener);
        handleMapAllowOriginChangeListener.put(listener, handle);
    }

    public synchronized void removeAllowOriginChangeListener(com.ericsson.research.owr.ImageServer.AllowOriginChangeListener listener) {
        if (handleMapAllowOriginChangeListener == null) {
            handleMapAllowOriginChangeListener = new java.util.HashMap<AllowOriginChangeListener, Integer>();
        }

        Integer current = handleMapAllowOriginChangeListener.remove(listener);
        if (current != null) {
            disconnectAllowOriginChangeListener(current);
        }
    }

    public native int getPort();

    private java.util.HashMap<PortChangeListener, Integer> handleMapPortChangeListener;

    public static interface PortChangeListener {
        public void onPortChanged(int port);
    }

    private native int connectPortChangeListener(com.ericsson.research.owr.ImageServer.PortChangeListener listener);

    private native void disconnectPortChangeListener(int handle);

    public synchronized void addPortChangeListener(com.ericsson.research.owr.ImageServer.PortChangeListener listener) {
        if (handleMapPortChangeListener == null) {
            handleMapPortChangeListener = new java.util.HashMap<PortChangeListener, Integer>();
        }

        Integer current = handleMapPortChangeListener.remove(listener);
        if (current != null) {
            disconnectPortChangeListener(current);
        }

        int handle = connectPortChangeListener(listener);
        handleMapPortChangeListener.put(listener, handle);
    }

    public synchronized void removePortChangeListener(com.ericsson.research.owr.ImageServer.PortChangeListener listener) {
        if (handleMapPortChangeListener == null) {
            handleMapPortChangeListener = new java.util.HashMap<PortChangeListener, Integer>();
        }

        Integer current = handleMapPortChangeListener.remove(listener);
        if (current != null) {
            disconnectPortChangeListener(current);
        }
    }
}