package com.ericsson.research.owr;

import com.ericsson.research.NativeInstance;
import com.ericsson.research.NativePointer;

public class ImageRenderer extends MediaRenderer {
    public ImageRenderer() {
        super(_newNativePointer(0));
        long pointer = nativeConstructor();
        _setInternalPointer(pointer);
    }
    native long nativeConstructor();

    ImageRenderer(NativePointer nativePointer) {
        super(nativePointer);
    }

    public native void setHeight(int height);

    public native int getHeight();

    private java.util.HashMap<HeightChangeListener, Integer> handleMapHeightChangeListener;

    public static interface HeightChangeListener {
        public void onHeightChanged(int height);
    }

    private native int connectHeightChangeListener(com.ericsson.research.owr.ImageRenderer.HeightChangeListener listener);

    private native void disconnectHeightChangeListener(int handle);

    public synchronized void addHeightChangeListener(com.ericsson.research.owr.ImageRenderer.HeightChangeListener listener) {
        if (handleMapHeightChangeListener == null) {
            handleMapHeightChangeListener = new java.util.HashMap<HeightChangeListener, Integer>();
        }

        Integer current = handleMapHeightChangeListener.remove(listener);
        if (current != null) {
            disconnectHeightChangeListener(current);
        }

        int handle = connectHeightChangeListener(listener);
        handleMapHeightChangeListener.put(listener, handle);
    }

    public synchronized void removeHeightChangeListener(com.ericsson.research.owr.ImageRenderer.HeightChangeListener listener) {
        if (handleMapHeightChangeListener == null) {
            handleMapHeightChangeListener = new java.util.HashMap<HeightChangeListener, Integer>();
        }

        Integer current = handleMapHeightChangeListener.remove(listener);
        if (current != null) {
            disconnectHeightChangeListener(current);
        }
    }

    public native void setMaxFramerate(double maxFramerate);

    public native double getMaxFramerate();

    private java.util.HashMap<MaxFramerateChangeListener, Integer> handleMapMaxFramerateChangeListener;

    public static interface MaxFramerateChangeListener {
        public void onMaxFramerateChanged(double maxFramerate);
    }

    private native int connectMaxFramerateChangeListener(com.ericsson.research.owr.ImageRenderer.MaxFramerateChangeListener listener);

    private native void disconnectMaxFramerateChangeListener(int handle);

    public synchronized void addMaxFramerateChangeListener(com.ericsson.research.owr.ImageRenderer.MaxFramerateChangeListener listener) {
        if (handleMapMaxFramerateChangeListener == null) {
            handleMapMaxFramerateChangeListener = new java.util.HashMap<MaxFramerateChangeListener, Integer>();
        }

        Integer current = handleMapMaxFramerateChangeListener.remove(listener);
        if (current != null) {
            disconnectMaxFramerateChangeListener(current);
        }

        int handle = connectMaxFramerateChangeListener(listener);
        handleMapMaxFramerateChangeListener.put(listener, handle);
    }

    public synchronized void removeMaxFramerateChangeListener(com.ericsson.research.owr.ImageRenderer.MaxFramerateChangeListener listener) {
        if (handleMapMaxFramerateChangeListener == null) {
            handleMapMaxFramerateChangeListener = new java.util.HashMap<MaxFramerateChangeListener, Integer>();
        }

        Integer current = handleMapMaxFramerateChangeListener.remove(listener);
        if (current != null) {
            disconnectMaxFramerateChangeListener(current);
        }
    }

    public native void setWidth(int width);

    public native int getWidth();

    private java.util.HashMap<WidthChangeListener, Integer> handleMapWidthChangeListener;

    public static interface WidthChangeListener {
        public void onWidthChanged(int width);
    }

    private native int connectWidthChangeListener(com.ericsson.research.owr.ImageRenderer.WidthChangeListener listener);

    private native void disconnectWidthChangeListener(int handle);

    public synchronized void addWidthChangeListener(com.ericsson.research.owr.ImageRenderer.WidthChangeListener listener) {
        if (handleMapWidthChangeListener == null) {
            handleMapWidthChangeListener = new java.util.HashMap<WidthChangeListener, Integer>();
        }

        Integer current = handleMapWidthChangeListener.remove(listener);
        if (current != null) {
            disconnectWidthChangeListener(current);
        }

        int handle = connectWidthChangeListener(listener);
        handleMapWidthChangeListener.put(listener, handle);
    }

    public synchronized void removeWidthChangeListener(com.ericsson.research.owr.ImageRenderer.WidthChangeListener listener) {
        if (handleMapWidthChangeListener == null) {
            handleMapWidthChangeListener = new java.util.HashMap<WidthChangeListener, Integer>();
        }

        Integer current = handleMapWidthChangeListener.remove(listener);
        if (current != null) {
            disconnectWidthChangeListener(current);
        }
    }
}