package com.ericsson.research.owr;

import com.ericsson.research.ValueEnum;

public enum IceState implements ValueEnum {
    DISCONNECTED(0, "disconnected"),
    GATHERING(1, "gathering"),
    CONNECTING(2, "connecting"),
    CONNECTED(3, "connected"),
    READY(4, "ready"),
    FAILED(5, "failed");

    private final int mValue;
    private final String mNick;

    private IceState(int value, String nick) {
        mValue = value;
        mNick = nick;
    }

    public int getValue() {
        return mValue;
    }

    public String getNick() {
        return mNick;
    }

    public static IceState valueOfNick(String nick) {
        if ("disconnected".equals(nick)) {
            return DISCONNECTED;
        } else if ("gathering".equals(nick)) {
            return GATHERING;
        } else if ("connecting".equals(nick)) {
            return CONNECTING;
        } else if ("connected".equals(nick)) {
            return CONNECTED;
        } else if ("ready".equals(nick)) {
            return READY;
        } else if ("failed".equals(nick)) {
            return FAILED;
        } else {
            throw new IllegalArgumentException("Invalid enum nick: " + nick);
        }
    }
}