package com.ericsson.research.owr;

import com.ericsson.research.NativeInstance;
import com.ericsson.research.NativePointer;

public class DataSession extends Session {
    public DataSession(boolean dtls_client_mode) {
        super(_newNativePointer(0));
        long pointer = nativeConstructor(dtls_client_mode);
        _setInternalPointer(pointer);
    }
    native long nativeConstructor(boolean dtls_client_mode);

    DataSession(NativePointer nativePointer) {
        super(nativePointer);
    }

    public native void addDataChannel(com.ericsson.research.owr.DataChannel data_channel);

    public native void setSctpLocalPort(int sctpLocalPort);

    public native int getSctpLocalPort();

    private java.util.HashMap<SctpLocalPortChangeListener, Integer> handleMapSctpLocalPortChangeListener;

    public static interface SctpLocalPortChangeListener {
        public void onSctpLocalPortChanged(int sctpLocalPort);
    }

    private native int connectSctpLocalPortChangeListener(com.ericsson.research.owr.DataSession.SctpLocalPortChangeListener listener);

    private native void disconnectSctpLocalPortChangeListener(int handle);

    public synchronized void addSctpLocalPortChangeListener(com.ericsson.research.owr.DataSession.SctpLocalPortChangeListener listener) {
        if (handleMapSctpLocalPortChangeListener == null) {
            handleMapSctpLocalPortChangeListener = new java.util.HashMap<SctpLocalPortChangeListener, Integer>();
        }

        Integer current = handleMapSctpLocalPortChangeListener.remove(listener);
        if (current != null) {
            disconnectSctpLocalPortChangeListener(current);
        }

        int handle = connectSctpLocalPortChangeListener(listener);
        handleMapSctpLocalPortChangeListener.put(listener, handle);
    }

    public synchronized void removeSctpLocalPortChangeListener(com.ericsson.research.owr.DataSession.SctpLocalPortChangeListener listener) {
        if (handleMapSctpLocalPortChangeListener == null) {
            handleMapSctpLocalPortChangeListener = new java.util.HashMap<SctpLocalPortChangeListener, Integer>();
        }

        Integer current = handleMapSctpLocalPortChangeListener.remove(listener);
        if (current != null) {
            disconnectSctpLocalPortChangeListener(current);
        }
    }

    public native void setSctpRemotePort(int sctpRemotePort);

    public native int getSctpRemotePort();

    private java.util.HashMap<SctpRemotePortChangeListener, Integer> handleMapSctpRemotePortChangeListener;

    public static interface SctpRemotePortChangeListener {
        public void onSctpRemotePortChanged(int sctpRemotePort);
    }

    private native int connectSctpRemotePortChangeListener(com.ericsson.research.owr.DataSession.SctpRemotePortChangeListener listener);

    private native void disconnectSctpRemotePortChangeListener(int handle);

    public synchronized void addSctpRemotePortChangeListener(com.ericsson.research.owr.DataSession.SctpRemotePortChangeListener listener) {
        if (handleMapSctpRemotePortChangeListener == null) {
            handleMapSctpRemotePortChangeListener = new java.util.HashMap<SctpRemotePortChangeListener, Integer>();
        }

        Integer current = handleMapSctpRemotePortChangeListener.remove(listener);
        if (current != null) {
            disconnectSctpRemotePortChangeListener(current);
        }

        int handle = connectSctpRemotePortChangeListener(listener);
        handleMapSctpRemotePortChangeListener.put(listener, handle);
    }

    public synchronized void removeSctpRemotePortChangeListener(com.ericsson.research.owr.DataSession.SctpRemotePortChangeListener listener) {
        if (handleMapSctpRemotePortChangeListener == null) {
            handleMapSctpRemotePortChangeListener = new java.util.HashMap<SctpRemotePortChangeListener, Integer>();
        }

        Integer current = handleMapSctpRemotePortChangeListener.remove(listener);
        if (current != null) {
            disconnectSctpRemotePortChangeListener(current);
        }
    }

    public native void setUseSockStream(boolean useSockStream);

    public native boolean getUseSockStream();

    private java.util.HashMap<UseSockStreamChangeListener, Integer> handleMapUseSockStreamChangeListener;

    public static interface UseSockStreamChangeListener {
        public void onUseSockStreamChanged(boolean useSockStream);
    }

    private native int connectUseSockStreamChangeListener(com.ericsson.research.owr.DataSession.UseSockStreamChangeListener listener);

    private native void disconnectUseSockStreamChangeListener(int handle);

    public synchronized void addUseSockStreamChangeListener(com.ericsson.research.owr.DataSession.UseSockStreamChangeListener listener) {
        if (handleMapUseSockStreamChangeListener == null) {
            handleMapUseSockStreamChangeListener = new java.util.HashMap<UseSockStreamChangeListener, Integer>();
        }

        Integer current = handleMapUseSockStreamChangeListener.remove(listener);
        if (current != null) {
            disconnectUseSockStreamChangeListener(current);
        }

        int handle = connectUseSockStreamChangeListener(listener);
        handleMapUseSockStreamChangeListener.put(listener, handle);
    }

    public synchronized void removeUseSockStreamChangeListener(com.ericsson.research.owr.DataSession.UseSockStreamChangeListener listener) {
        if (handleMapUseSockStreamChangeListener == null) {
            handleMapUseSockStreamChangeListener = new java.util.HashMap<UseSockStreamChangeListener, Integer>();
        }

        Integer current = handleMapUseSockStreamChangeListener.remove(listener);
        if (current != null) {
            disconnectUseSockStreamChangeListener(current);
        }
    }

    private java.util.HashMap<OnDataChannelRequestedListener, Integer> handleMapOnDataChannelRequestedListener;

    public static interface OnDataChannelRequestedListener {
        public void onDataChannelRequested(boolean object, int p0, int p1, java.lang.String p2, boolean p3, int p4, java.lang.String p5);
    }

    private native int connectOnDataChannelRequestedListener(com.ericsson.research.owr.DataSession.OnDataChannelRequestedListener listener);

    private native void disconnectOnDataChannelRequestedListener(int handle);

    public synchronized void addOnDataChannelRequestedListener(com.ericsson.research.owr.DataSession.OnDataChannelRequestedListener listener) {
        if (handleMapOnDataChannelRequestedListener == null) {
            handleMapOnDataChannelRequestedListener = new java.util.HashMap<OnDataChannelRequestedListener, Integer>();
        }

        Integer current = handleMapOnDataChannelRequestedListener.remove(listener);
        if (current != null) {
            disconnectOnDataChannelRequestedListener(current);
        }

        int handle = connectOnDataChannelRequestedListener(listener);
        handleMapOnDataChannelRequestedListener.put(listener, handle);
    }

    public synchronized void removeOnDataChannelRequestedListener(com.ericsson.research.owr.DataSession.OnDataChannelRequestedListener listener) {
        if (handleMapOnDataChannelRequestedListener == null) {
            handleMapOnDataChannelRequestedListener = new java.util.HashMap<OnDataChannelRequestedListener, Integer>();
        }

        Integer current = handleMapOnDataChannelRequestedListener.remove(listener);
        if (current != null) {
            disconnectOnDataChannelRequestedListener(current);
        }
    }
}