package com.ericsson.research.owr;

import com.ericsson.research.ValueEnum;

public enum DataChannelReadyState implements ValueEnum {
    CONNECTING(0, "ready-state-connecting"),
    OPEN(1, "ready-state-open"),
    CLOSING(2, "ready-state-closing"),
    CLOSED(3, "ready-state-closed");

    private final int mValue;
    private final String mNick;

    private DataChannelReadyState(int value, String nick) {
        mValue = value;
        mNick = nick;
    }

    public int getValue() {
        return mValue;
    }

    public String getNick() {
        return mNick;
    }

    public static DataChannelReadyState valueOfNick(String nick) {
        if ("ready-state-connecting".equals(nick)) {
            return CONNECTING;
        } else if ("ready-state-open".equals(nick)) {
            return OPEN;
        } else if ("ready-state-closing".equals(nick)) {
            return CLOSING;
        } else if ("ready-state-closed".equals(nick)) {
            return CLOSED;
        } else {
            throw new IllegalArgumentException("Invalid enum nick: " + nick);
        }
    }
}