package com.ericsson.research.owr;

import com.ericsson.research.NativeInstance;
import com.ericsson.research.NativePointer;

public class DataChannel extends NativeInstance {
    public DataChannel(boolean ordered, int max_packet_life_time, int max_retransmits, java.lang.String protocol, boolean negotiated, short id, java.lang.String label) {
        super(_newNativePointer(0));
        long pointer = nativeConstructor(ordered, max_packet_life_time, max_retransmits, protocol, negotiated, id, label);
        _setInternalPointer(pointer);
    }
    native long nativeConstructor(boolean ordered, int max_packet_life_time, int max_retransmits, java.lang.String protocol, boolean negotiated, short id, java.lang.String label);

    DataChannel(NativePointer nativePointer) {
        super(nativePointer);
    }

    public native void close();

    public native void send(java.lang.String data);

    public native void sendBinary(byte[] data);

    public native int getBufferedAmount();

    private java.util.HashMap<BufferedAmountChangeListener, Integer> handleMapBufferedAmountChangeListener;

    public static interface BufferedAmountChangeListener {
        public void onBufferedAmountChanged(int bufferedAmount);
    }

    private native int connectBufferedAmountChangeListener(com.ericsson.research.owr.DataChannel.BufferedAmountChangeListener listener);

    private native void disconnectBufferedAmountChangeListener(int handle);

    public synchronized void addBufferedAmountChangeListener(com.ericsson.research.owr.DataChannel.BufferedAmountChangeListener listener) {
        if (handleMapBufferedAmountChangeListener == null) {
            handleMapBufferedAmountChangeListener = new java.util.HashMap<BufferedAmountChangeListener, Integer>();
        }

        Integer current = handleMapBufferedAmountChangeListener.remove(listener);
        if (current != null) {
            disconnectBufferedAmountChangeListener(current);
        }

        int handle = connectBufferedAmountChangeListener(listener);
        handleMapBufferedAmountChangeListener.put(listener, handle);
    }

    public synchronized void removeBufferedAmountChangeListener(com.ericsson.research.owr.DataChannel.BufferedAmountChangeListener listener) {
        if (handleMapBufferedAmountChangeListener == null) {
            handleMapBufferedAmountChangeListener = new java.util.HashMap<BufferedAmountChangeListener, Integer>();
        }

        Integer current = handleMapBufferedAmountChangeListener.remove(listener);
        if (current != null) {
            disconnectBufferedAmountChangeListener(current);
        }
    }

    public native int getId();

    private java.util.HashMap<IdChangeListener, Integer> handleMapIdChangeListener;

    public static interface IdChangeListener {
        public void onIdChanged(int id);
    }

    private native int connectIdChangeListener(com.ericsson.research.owr.DataChannel.IdChangeListener listener);

    private native void disconnectIdChangeListener(int handle);

    public synchronized void addIdChangeListener(com.ericsson.research.owr.DataChannel.IdChangeListener listener) {
        if (handleMapIdChangeListener == null) {
            handleMapIdChangeListener = new java.util.HashMap<IdChangeListener, Integer>();
        }

        Integer current = handleMapIdChangeListener.remove(listener);
        if (current != null) {
            disconnectIdChangeListener(current);
        }

        int handle = connectIdChangeListener(listener);
        handleMapIdChangeListener.put(listener, handle);
    }

    public synchronized void removeIdChangeListener(com.ericsson.research.owr.DataChannel.IdChangeListener listener) {
        if (handleMapIdChangeListener == null) {
            handleMapIdChangeListener = new java.util.HashMap<IdChangeListener, Integer>();
        }

        Integer current = handleMapIdChangeListener.remove(listener);
        if (current != null) {
            disconnectIdChangeListener(current);
        }
    }

    public native java.lang.String getLabel();

    private java.util.HashMap<LabelChangeListener, Integer> handleMapLabelChangeListener;

    public static interface LabelChangeListener {
        public void onLabelChanged(java.lang.String label);
    }

    private native int connectLabelChangeListener(com.ericsson.research.owr.DataChannel.LabelChangeListener listener);

    private native void disconnectLabelChangeListener(int handle);

    public synchronized void addLabelChangeListener(com.ericsson.research.owr.DataChannel.LabelChangeListener listener) {
        if (handleMapLabelChangeListener == null) {
            handleMapLabelChangeListener = new java.util.HashMap<LabelChangeListener, Integer>();
        }

        Integer current = handleMapLabelChangeListener.remove(listener);
        if (current != null) {
            disconnectLabelChangeListener(current);
        }

        int handle = connectLabelChangeListener(listener);
        handleMapLabelChangeListener.put(listener, handle);
    }

    public synchronized void removeLabelChangeListener(com.ericsson.research.owr.DataChannel.LabelChangeListener listener) {
        if (handleMapLabelChangeListener == null) {
            handleMapLabelChangeListener = new java.util.HashMap<LabelChangeListener, Integer>();
        }

        Integer current = handleMapLabelChangeListener.remove(listener);
        if (current != null) {
            disconnectLabelChangeListener(current);
        }
    }

    public native int getMaxPacketLifeTime();

    private java.util.HashMap<MaxPacketLifeTimeChangeListener, Integer> handleMapMaxPacketLifeTimeChangeListener;

    public static interface MaxPacketLifeTimeChangeListener {
        public void onMaxPacketLifeTimeChanged(int maxPacketLifeTime);
    }

    private native int connectMaxPacketLifeTimeChangeListener(com.ericsson.research.owr.DataChannel.MaxPacketLifeTimeChangeListener listener);

    private native void disconnectMaxPacketLifeTimeChangeListener(int handle);

    public synchronized void addMaxPacketLifeTimeChangeListener(com.ericsson.research.owr.DataChannel.MaxPacketLifeTimeChangeListener listener) {
        if (handleMapMaxPacketLifeTimeChangeListener == null) {
            handleMapMaxPacketLifeTimeChangeListener = new java.util.HashMap<MaxPacketLifeTimeChangeListener, Integer>();
        }

        Integer current = handleMapMaxPacketLifeTimeChangeListener.remove(listener);
        if (current != null) {
            disconnectMaxPacketLifeTimeChangeListener(current);
        }

        int handle = connectMaxPacketLifeTimeChangeListener(listener);
        handleMapMaxPacketLifeTimeChangeListener.put(listener, handle);
    }

    public synchronized void removeMaxPacketLifeTimeChangeListener(com.ericsson.research.owr.DataChannel.MaxPacketLifeTimeChangeListener listener) {
        if (handleMapMaxPacketLifeTimeChangeListener == null) {
            handleMapMaxPacketLifeTimeChangeListener = new java.util.HashMap<MaxPacketLifeTimeChangeListener, Integer>();
        }

        Integer current = handleMapMaxPacketLifeTimeChangeListener.remove(listener);
        if (current != null) {
            disconnectMaxPacketLifeTimeChangeListener(current);
        }
    }

    public native int getMaxRetransmits();

    private java.util.HashMap<MaxRetransmitsChangeListener, Integer> handleMapMaxRetransmitsChangeListener;

    public static interface MaxRetransmitsChangeListener {
        public void onMaxRetransmitsChanged(int maxRetransmits);
    }

    private native int connectMaxRetransmitsChangeListener(com.ericsson.research.owr.DataChannel.MaxRetransmitsChangeListener listener);

    private native void disconnectMaxRetransmitsChangeListener(int handle);

    public synchronized void addMaxRetransmitsChangeListener(com.ericsson.research.owr.DataChannel.MaxRetransmitsChangeListener listener) {
        if (handleMapMaxRetransmitsChangeListener == null) {
            handleMapMaxRetransmitsChangeListener = new java.util.HashMap<MaxRetransmitsChangeListener, Integer>();
        }

        Integer current = handleMapMaxRetransmitsChangeListener.remove(listener);
        if (current != null) {
            disconnectMaxRetransmitsChangeListener(current);
        }

        int handle = connectMaxRetransmitsChangeListener(listener);
        handleMapMaxRetransmitsChangeListener.put(listener, handle);
    }

    public synchronized void removeMaxRetransmitsChangeListener(com.ericsson.research.owr.DataChannel.MaxRetransmitsChangeListener listener) {
        if (handleMapMaxRetransmitsChangeListener == null) {
            handleMapMaxRetransmitsChangeListener = new java.util.HashMap<MaxRetransmitsChangeListener, Integer>();
        }

        Integer current = handleMapMaxRetransmitsChangeListener.remove(listener);
        if (current != null) {
            disconnectMaxRetransmitsChangeListener(current);
        }
    }

    public native boolean getNegotiated();

    private java.util.HashMap<NegotiatedChangeListener, Integer> handleMapNegotiatedChangeListener;

    public static interface NegotiatedChangeListener {
        public void onNegotiatedChanged(boolean negotiated);
    }

    private native int connectNegotiatedChangeListener(com.ericsson.research.owr.DataChannel.NegotiatedChangeListener listener);

    private native void disconnectNegotiatedChangeListener(int handle);

    public synchronized void addNegotiatedChangeListener(com.ericsson.research.owr.DataChannel.NegotiatedChangeListener listener) {
        if (handleMapNegotiatedChangeListener == null) {
            handleMapNegotiatedChangeListener = new java.util.HashMap<NegotiatedChangeListener, Integer>();
        }

        Integer current = handleMapNegotiatedChangeListener.remove(listener);
        if (current != null) {
            disconnectNegotiatedChangeListener(current);
        }

        int handle = connectNegotiatedChangeListener(listener);
        handleMapNegotiatedChangeListener.put(listener, handle);
    }

    public synchronized void removeNegotiatedChangeListener(com.ericsson.research.owr.DataChannel.NegotiatedChangeListener listener) {
        if (handleMapNegotiatedChangeListener == null) {
            handleMapNegotiatedChangeListener = new java.util.HashMap<NegotiatedChangeListener, Integer>();
        }

        Integer current = handleMapNegotiatedChangeListener.remove(listener);
        if (current != null) {
            disconnectNegotiatedChangeListener(current);
        }
    }

    public native boolean getOrdered();

    private java.util.HashMap<OrderedChangeListener, Integer> handleMapOrderedChangeListener;

    public static interface OrderedChangeListener {
        public void onOrderedChanged(boolean ordered);
    }

    private native int connectOrderedChangeListener(com.ericsson.research.owr.DataChannel.OrderedChangeListener listener);

    private native void disconnectOrderedChangeListener(int handle);

    public synchronized void addOrderedChangeListener(com.ericsson.research.owr.DataChannel.OrderedChangeListener listener) {
        if (handleMapOrderedChangeListener == null) {
            handleMapOrderedChangeListener = new java.util.HashMap<OrderedChangeListener, Integer>();
        }

        Integer current = handleMapOrderedChangeListener.remove(listener);
        if (current != null) {
            disconnectOrderedChangeListener(current);
        }

        int handle = connectOrderedChangeListener(listener);
        handleMapOrderedChangeListener.put(listener, handle);
    }

    public synchronized void removeOrderedChangeListener(com.ericsson.research.owr.DataChannel.OrderedChangeListener listener) {
        if (handleMapOrderedChangeListener == null) {
            handleMapOrderedChangeListener = new java.util.HashMap<OrderedChangeListener, Integer>();
        }

        Integer current = handleMapOrderedChangeListener.remove(listener);
        if (current != null) {
            disconnectOrderedChangeListener(current);
        }
    }

    public native java.lang.String getProtocol();

    private java.util.HashMap<ProtocolChangeListener, Integer> handleMapProtocolChangeListener;

    public static interface ProtocolChangeListener {
        public void onProtocolChanged(java.lang.String protocol);
    }

    private native int connectProtocolChangeListener(com.ericsson.research.owr.DataChannel.ProtocolChangeListener listener);

    private native void disconnectProtocolChangeListener(int handle);

    public synchronized void addProtocolChangeListener(com.ericsson.research.owr.DataChannel.ProtocolChangeListener listener) {
        if (handleMapProtocolChangeListener == null) {
            handleMapProtocolChangeListener = new java.util.HashMap<ProtocolChangeListener, Integer>();
        }

        Integer current = handleMapProtocolChangeListener.remove(listener);
        if (current != null) {
            disconnectProtocolChangeListener(current);
        }

        int handle = connectProtocolChangeListener(listener);
        handleMapProtocolChangeListener.put(listener, handle);
    }

    public synchronized void removeProtocolChangeListener(com.ericsson.research.owr.DataChannel.ProtocolChangeListener listener) {
        if (handleMapProtocolChangeListener == null) {
            handleMapProtocolChangeListener = new java.util.HashMap<ProtocolChangeListener, Integer>();
        }

        Integer current = handleMapProtocolChangeListener.remove(listener);
        if (current != null) {
            disconnectProtocolChangeListener(current);
        }
    }

    public native com.ericsson.research.owr.DataChannelReadyState getReadyState();

    private java.util.HashMap<ReadyStateChangeListener, Integer> handleMapReadyStateChangeListener;

    public static interface ReadyStateChangeListener {
        public void onReadyStateChanged(com.ericsson.research.owr.DataChannelReadyState readyState);
    }

    private native int connectReadyStateChangeListener(com.ericsson.research.owr.DataChannel.ReadyStateChangeListener listener);

    private native void disconnectReadyStateChangeListener(int handle);

    public synchronized void addReadyStateChangeListener(com.ericsson.research.owr.DataChannel.ReadyStateChangeListener listener) {
        if (handleMapReadyStateChangeListener == null) {
            handleMapReadyStateChangeListener = new java.util.HashMap<ReadyStateChangeListener, Integer>();
        }

        Integer current = handleMapReadyStateChangeListener.remove(listener);
        if (current != null) {
            disconnectReadyStateChangeListener(current);
        }

        int handle = connectReadyStateChangeListener(listener);
        handleMapReadyStateChangeListener.put(listener, handle);
    }

    public synchronized void removeReadyStateChangeListener(com.ericsson.research.owr.DataChannel.ReadyStateChangeListener listener) {
        if (handleMapReadyStateChangeListener == null) {
            handleMapReadyStateChangeListener = new java.util.HashMap<ReadyStateChangeListener, Integer>();
        }

        Integer current = handleMapReadyStateChangeListener.remove(listener);
        if (current != null) {
            disconnectReadyStateChangeListener(current);
        }
    }

    private java.util.HashMap<OnBinaryDataListener, Integer> handleMapOnBinaryDataListener;

    public static interface OnBinaryDataListener {
        public void onBinaryData(byte[] binary_data);
    }

    private native int connectOnBinaryDataListener(com.ericsson.research.owr.DataChannel.OnBinaryDataListener listener);

    private native void disconnectOnBinaryDataListener(int handle);

    public synchronized void addOnBinaryDataListener(com.ericsson.research.owr.DataChannel.OnBinaryDataListener listener) {
        if (handleMapOnBinaryDataListener == null) {
            handleMapOnBinaryDataListener = new java.util.HashMap<OnBinaryDataListener, Integer>();
        }

        Integer current = handleMapOnBinaryDataListener.remove(listener);
        if (current != null) {
            disconnectOnBinaryDataListener(current);
        }

        int handle = connectOnBinaryDataListener(listener);
        handleMapOnBinaryDataListener.put(listener, handle);
    }

    public synchronized void removeOnBinaryDataListener(com.ericsson.research.owr.DataChannel.OnBinaryDataListener listener) {
        if (handleMapOnBinaryDataListener == null) {
            handleMapOnBinaryDataListener = new java.util.HashMap<OnBinaryDataListener, Integer>();
        }

        Integer current = handleMapOnBinaryDataListener.remove(listener);
        if (current != null) {
            disconnectOnBinaryDataListener(current);
        }
    }

    private java.util.HashMap<OnDataListener, Integer> handleMapOnDataListener;

    public static interface OnDataListener {
        public void onData(java.lang.String object);
    }

    private native int connectOnDataListener(com.ericsson.research.owr.DataChannel.OnDataListener listener);

    private native void disconnectOnDataListener(int handle);

    public synchronized void addOnDataListener(com.ericsson.research.owr.DataChannel.OnDataListener listener) {
        if (handleMapOnDataListener == null) {
            handleMapOnDataListener = new java.util.HashMap<OnDataListener, Integer>();
        }

        Integer current = handleMapOnDataListener.remove(listener);
        if (current != null) {
            disconnectOnDataListener(current);
        }

        int handle = connectOnDataListener(listener);
        handleMapOnDataListener.put(listener, handle);
    }

    public synchronized void removeOnDataListener(com.ericsson.research.owr.DataChannel.OnDataListener listener) {
        if (handleMapOnDataListener == null) {
            handleMapOnDataListener = new java.util.HashMap<OnDataListener, Integer>();
        }

        Integer current = handleMapOnDataListener.remove(listener);
        if (current != null) {
            disconnectOnDataListener(current);
        }
    }
}