package com.ericsson.research.owr;

import com.ericsson.research.ValueEnum;

public enum ComponentType implements ValueEnum {
    RTP(1, "rtp"),
    RTCP(2, "rtcp");

    private final int mValue;
    private final String mNick;

    private ComponentType(int value, String nick) {
        mValue = value;
        mNick = nick;
    }

    public int getValue() {
        return mValue;
    }

    public String getNick() {
        return mNick;
    }

    public static ComponentType valueOfNick(String nick) {
        if ("rtp".equals(nick)) {
            return RTP;
        } else if ("rtcp".equals(nick)) {
            return RTCP;
        } else {
            throw new IllegalArgumentException("Invalid enum nick: " + nick);
        }
    }
}