package com.ericsson.research.owr;

import com.ericsson.research.ValueEnum;

public enum CodecType implements ValueEnum {
    NONE(0, "raw"),
    PCMU(1, "pcmu"),
    PCMA(2, "pcma"),
    OPUS(3, "opus"),
    H264(4, "h264"),
    VP8(5, "vp8");

    private final int mValue;
    private final String mNick;

    private CodecType(int value, String nick) {
        mValue = value;
        mNick = nick;
    }

    public int getValue() {
        return mValue;
    }

    public String getNick() {
        return mNick;
    }

    public static CodecType valueOfNick(String nick) {
        if ("raw".equals(nick)) {
            return NONE;
        } else if ("pcmu".equals(nick)) {
            return PCMU;
        } else if ("pcma".equals(nick)) {
            return PCMA;
        } else if ("opus".equals(nick)) {
            return OPUS;
        } else if ("h264".equals(nick)) {
            return H264;
        } else if ("vp8".equals(nick)) {
            return VP8;
        } else {
            throw new IllegalArgumentException("Invalid enum nick: " + nick);
        }
    }
}