package com.ericsson.research.owr;

import com.ericsson.research.ValueEnum;

public enum CandidateType implements ValueEnum {
    HOST(0, "host"),
    SERVER_REFLEXIVE(1, "srflx"),
    PEER_REFLEXIVE(2, "prflx"),
    RELAY(3, "relay");

    private final int mValue;
    private final String mNick;

    private CandidateType(int value, String nick) {
        mValue = value;
        mNick = nick;
    }

    public int getValue() {
        return mValue;
    }

    public String getNick() {
        return mNick;
    }

    public static CandidateType valueOfNick(String nick) {
        if ("host".equals(nick)) {
            return HOST;
        } else if ("srflx".equals(nick)) {
            return SERVER_REFLEXIVE;
        } else if ("prflx".equals(nick)) {
            return PEER_REFLEXIVE;
        } else if ("relay".equals(nick)) {
            return RELAY;
        } else {
            throw new IllegalArgumentException("Invalid enum nick: " + nick);
        }
    }
}