package com.ericsson.research.owr;

import com.ericsson.research.NativeInstance;
import com.ericsson.research.NativePointer;

public class AudioPayload extends Payload {
    public AudioPayload(com.ericsson.research.owr.CodecType codec_type, int payload_type, int clock_rate, int channels) {
        super(_newNativePointer(0));
        long pointer = nativeConstructor(codec_type, payload_type, clock_rate, channels);
        _setInternalPointer(pointer);
    }
    native long nativeConstructor(com.ericsson.research.owr.CodecType codec_type, int payload_type, int clock_rate, int channels);

    AudioPayload(NativePointer nativePointer) {
        super(nativePointer);
    }

    public native int getChannels();

    private java.util.HashMap<ChannelsChangeListener, Integer> handleMapChannelsChangeListener;

    public static interface ChannelsChangeListener {
        public void onChannelsChanged(int channels);
    }

    private native int connectChannelsChangeListener(com.ericsson.research.owr.AudioPayload.ChannelsChangeListener listener);

    private native void disconnectChannelsChangeListener(int handle);

    public synchronized void addChannelsChangeListener(com.ericsson.research.owr.AudioPayload.ChannelsChangeListener listener) {
        if (handleMapChannelsChangeListener == null) {
            handleMapChannelsChangeListener = new java.util.HashMap<ChannelsChangeListener, Integer>();
        }

        Integer current = handleMapChannelsChangeListener.remove(listener);
        if (current != null) {
            disconnectChannelsChangeListener(current);
        }

        int handle = connectChannelsChangeListener(listener);
        handleMapChannelsChangeListener.put(listener, handle);
    }

    public synchronized void removeChannelsChangeListener(com.ericsson.research.owr.AudioPayload.ChannelsChangeListener listener) {
        if (handleMapChannelsChangeListener == null) {
            handleMapChannelsChangeListener = new java.util.HashMap<ChannelsChangeListener, Integer>();
        }

        Integer current = handleMapChannelsChangeListener.remove(listener);
        if (current != null) {
            disconnectChannelsChangeListener(current);
        }
    }

    public native void setPtime(int ptime);

    public native int getPtime();

    private java.util.HashMap<PtimeChangeListener, Integer> handleMapPtimeChangeListener;

    public static interface PtimeChangeListener {
        public void onPtimeChanged(int ptime);
    }

    private native int connectPtimeChangeListener(com.ericsson.research.owr.AudioPayload.PtimeChangeListener listener);

    private native void disconnectPtimeChangeListener(int handle);

    public synchronized void addPtimeChangeListener(com.ericsson.research.owr.AudioPayload.PtimeChangeListener listener) {
        if (handleMapPtimeChangeListener == null) {
            handleMapPtimeChangeListener = new java.util.HashMap<PtimeChangeListener, Integer>();
        }

        Integer current = handleMapPtimeChangeListener.remove(listener);
        if (current != null) {
            disconnectPtimeChangeListener(current);
        }

        int handle = connectPtimeChangeListener(listener);
        handleMapPtimeChangeListener.put(listener, handle);
    }

    public synchronized void removePtimeChangeListener(com.ericsson.research.owr.AudioPayload.PtimeChangeListener listener) {
        if (handleMapPtimeChangeListener == null) {
            handleMapPtimeChangeListener = new java.util.HashMap<PtimeChangeListener, Integer>();
        }

        Integer current = handleMapPtimeChangeListener.remove(listener);
        if (current != null) {
            disconnectPtimeChangeListener(current);
        }
    }
}